package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@EqualsAndHashCode(callSuper = true)
@Entity
@Table(name = "repair_order",indexes = {@Index(name = "idx_order_no",columnList = "order_no,tenantId",unique = true)})
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "repair_order", comment = "维修工单")
@Data
@Accessors(chain = true)
@ApiModel(value = "维修工单", description = "维修工单")
@Where(clause = "delete_flag = 0")
public class RepairOrderDO extends BaseModel  implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("工单单号")
    @Column(name = "order_no", columnDefinition = "varchar(255)  comment '工单单号'")
    String orderNo;

    @ApiModelProperty("车主信息id")
    @Column(name = "personal_id", columnDefinition = "bigint default 0  comment '车主信息id'")
    Long personalId;

    @ApiModelProperty("车主车辆信息id")
    @Column(name = "personal_vehicel_id", columnDefinition = "bigint default 0  comment '车主车辆信息id'")
    Long personalVehicelId;

    @ApiModelProperty("车辆来源")
    @Column(name = "vehicle_source", columnDefinition = "int(1) comment '车辆来源 1-立马 0-非立马'")
    private Integer vehicleSource;

    @ApiModelProperty("品牌名称")
    @Column(name = "brand_name", columnDefinition = "varchar(50) comment '品牌名称'")
    private String brandName;

    @ApiModelProperty("维修门店id")
    @Column(name = "repair_store_id", columnDefinition = "bigint default 0  comment '维修门店id'")
    Long repairStoreId;

    @ApiModelProperty("维修门店名称")
    @Column(name = "repair_store_name", columnDefinition = "varchar(255)  comment '维修门店名称'")
    String repairStoreName;

    @ApiModelProperty("维修门店编码")
    @Column(name = "repair_store_code", columnDefinition = "varchar(255)  comment '维修门店编码'")
    String repairStoreCode;

    @ApiModelProperty("购买门店id")
    @Column(name = "purchase_store_id", columnDefinition = "bigint default 0  comment '购买门店id'")
    Long purchaseStoreId;

    @ApiModelProperty("购买门店名称")
    @Column(name = "purchase_store_name", columnDefinition = "varchar(255)  comment '购买门店名称'")
    String purchaseStoreName;

    @ApiModelProperty("购买门店编码")
    @Column(name = "purchase_store_code", columnDefinition = "varchar(255)  comment '购买门店编码'")
    String purchaseStoreCode;

    @ApiModelProperty("购买时间")
    @Column(name = "purchase_time", columnDefinition = "datetime default null comment '购买时间'")
    private LocalDate purchaseTime;

    @ApiModelProperty("联系人")
    @Column(name = "order_person", columnDefinition = "varchar(255)  comment '联系人'")
    String orderPerson;

    @ApiModelProperty("联系电话")
    @Column(name = "order_tel", columnDefinition = "varchar(255)  comment '联系电话'")
    String orderTel;

    @ApiModelProperty("车架号")
    @Column(name = "vehicle_no", columnDefinition = "varchar(100)  comment '车架号'")
    String vehicleNo;

    @ApiModelProperty("车辆类型")
    @Column(name = "vehicle_type", columnDefinition = "varchar(100)  comment '车辆类型'")
    String vehicleType;

    @ApiModelProperty("问题描述")
    @Column(name = "question_remark", columnDefinition = "varchar(255)  comment '问题描述'")
    String questionRemark;

    @ApiModelProperty("工单状态")
    @Column(name = "order_status", columnDefinition = "varchar(50)  comment '工单状态'")
    String orderStatus;

    @ApiModelProperty("问题类型")
    @Column(name = "question_type", columnDefinition = "varchar(255)  comment '问题类型'")
    String questionType;

    @ApiModelProperty("维修方式")
    @Column(name = "repair_mode", columnDefinition = "varchar(50)  comment '维修方式'")
    String repairMode;

    @ApiModelProperty("接单时间")
    @Column(name = "receive_order_time", columnDefinition = "datetime default null comment '接单时间'")
    private LocalDateTime receiveOrderTime;

    @ApiModelProperty("完成时间")
    @Column(name = "complete_time", columnDefinition = "datetime default null comment '完成时间'")
    private LocalDateTime completeTime;

    @ApiModelProperty("C端取消原因udc")
    @Column(name = "cancel_reason_c", columnDefinition = "varchar(40) comment 'C端取消原因udc'")
    private String cancelReasonC;

    @ApiModelProperty("B端取消原因udc")
    @Column(name = "cancel_reason_b", columnDefinition = "varchar(40) comment 'B端取消原因udc'")
    private String cancelReasonB;

    @ApiModelProperty("取消备注")
    @Column(name = "cancel_remark", columnDefinition = "varchar(255)  comment '取消备注'")
    private String cancelRemark;

    @ApiModelProperty("维修备注")
    @Column(name = "repair_remark", columnDefinition = "varchar(255)  comment '维修备注'")
    private String repairRemark;

    @ApiModelProperty("业务员id")
    @Column(name = "salesman_id", columnDefinition = "bigint default 0  comment '业务员id'")
    Long salesmanId;

    @ApiModelProperty("业务员")
    @Column(name = "salesman", columnDefinition = "varchar(40)  comment '业务员'")
    private String salesman;

    @ApiModelProperty("服务类型")
    @Column(name = "service_type", columnDefinition = "int  comment '维修-1|保养-2|洗车-3|安装-4'")
    private Integer serviceType;




    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairOrderDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
