package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;


/**
 * @author : WWW
 * @date : 2023-5-24
 * @desc : 传输日志记录表
 */

@Entity
@Table(name="tem_transmission_log")
@org.hibernate.annotations.Table(appliesTo = "tem_transmission_log", comment = "传输日志记录表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class TemTransmissionLogDO extends BaseModel {


    /**
     * 源参数
     */
    @Column(name = "from_str", columnDefinition = "varchar(3000) comment '源参数'")
    private String fromStr;

    /**
     * 成功标记
     */
    @Column(name = "deal_flag", columnDefinition = "tinyint(1) comment '成功标记'")
    private Boolean dealFlag;

    /**
     * 来源平台
     */
    @Column(name = "source_platform", columnDefinition = "varchar(50) comment '来源平台'")
    private String sourcePlatform;

    /**
     * 返回响应
     */
    @Column(name = "ret_str", columnDefinition = "varchar(3000) comment '返回响应'")
    private String retStr;

    /**
     * 返回数量
     */
    @Column(name = "ret_num", columnDefinition = "bigint(20) comment '返回数量'")
    private Long retNum;


}