package com.elitesland.yst.production.aftersale.model.entity.orderlog;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 工单操作日志表;
 * @author : Karl.wang
 * @date : 2023-2-17
 */
@ApiModel(value = "工单操作日志表",description = "工单操作日志表")
@Table(name="order_log")
@Data
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "order_log", comment = "工单操作日志表")
@Entity
@Where(clause = "delete_flag = 0")
public class OrderLogDO extends BaseModel {
    @Comment("工单id")
    private Long orderId;

    @Comment("工单类型")
    private String orderType;

    @Comment("操作内容")
    private String operationContent;

//    @Comment("操作标题")
//    private String operationTitle;

    @Comment("操作时间")
    private LocalDateTime operationTime;

    @Comment("发起者账号")
    private String operationUser;

    @Comment("发起者账号id")
    private Long operationUserId;
}