package com.elitesland.yst.production.aftersale.model.entity.phonerecord;

import com.elitesland.yst.production.aftersale.model.vo.TreeModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@Entity
@Table(name = "phone_record_class", indexes = {
        @Index(name = "idx_pid", columnList = "pid")})
@org.hibernate.annotations.Table(appliesTo = "phone_record_class", comment = "400电话记录分类")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "phone_record_class", description = "400电话记录分类")
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class PhoneRecClsDO extends TreeModel {

    /** 试题分类名称 */
    @ApiModelProperty(value = "分类名称")
    @Column(name = "name", columnDefinition = "varchar(255)  comment '分类名称'")
    private String name;

    /** 试题分类名称 */
    @ApiModelProperty(value = "分类编码")
    @Column(name = "code", columnDefinition = "varchar(32)  comment '分类编码'")
    private String code;

    /** 简介 */
    @ApiModelProperty(value = "简介描述")
    @Column(name = "descr", columnDefinition = "varchar(2048)  comment '简介描述'")
    private String descr;

}
