package com.elitesland.yst.production.aftersale.model.entity.phonerecord;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import org.hibernate.annotations.Where;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录
 */
@Entity
@Table(name = "phone_record")
@org.hibernate.annotations.Table(appliesTo = "phone_record", comment = "电话记录")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PhoneRecordDO extends BaseModel {

    @Column(name = "record_time", columnDefinition = "datetime(6) comment '记录日期'")
    private LocalDateTime recordTime;

    @Column(name = "city_code", columnDefinition = "varchar(255) comment '城市编码'")
    private String cityCode;

    @Column(name = "city_name", columnDefinition = "varchar(255) comment '城市名称'")
    private String cityName;

    @Column(name = "addr", columnDefinition = "varchar(255) comment '地址'")
    private String addr;

    @Column(name = "contacts", columnDefinition = "varchar(100) comment '联络人'")
    private String contacts;

    @Column(name = "contact_phone", columnDefinition = "varchar(50) comment '联系电话'")
    private String contactPhone;

    @Column(name = "cust_type", columnDefinition = "varchar(255) comment '客户类型'")
    private String custType;

    @Column(name = "call_type", columnDefinition = "varchar(255) comment '来电类型'")
    private String callType;

    @Column(name = "sub_call_type", columnDefinition = "varchar(255) comment '下级来电类型'")
    private String subCallType;

    @Column(name = "call_content", columnDefinition = "varchar(255) comment '来电内容'")
    private String callContent;

    @Column(name = "process_result", columnDefinition = "varchar(255) comment '处理结果'")
    private String processResult;

    @Column(name = "relevant_department", columnDefinition = "varchar(255) comment '相关部门'")
    private String relevantDepartment;

    @Column(name = "follow_up_flag", columnDefinition = "tinyint(1) comment '是否回访'")
    private Boolean followUpFlag;

    @Column(name = "service_satisfied", columnDefinition = "int(11) comment '服务满意度'")
    private Integer serviceSatisfied;

    @Column(name = "other_opinion", columnDefinition = "varchar(255) comment '其他意见'")
    private String otherOpinion;

    @Column(name = "create_name", columnDefinition = "varchar(255) comment '记录人'")
    private String createName;

    @Column(name = "call_back_time", columnDefinition = "datetime(6) comment '回访时间'")
    private LocalDateTime callBackTime;
}