package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.LocalDateTime;

@Data
public class BatteryGuaranteesParam extends AbstractOrderQueryParam {

    @ApiModelProperty("商品统一编码")
    private String code;

    @ApiModelProperty("商品类型")
    private String type;

    @ApiModelProperty("厂家商品编码")
    private String fgCode;

    @ApiModelProperty("厂家编码")
    private String factoryCode;

    @ApiModelProperty("厂家名称")
    private String factoryName;

    @ApiModelProperty("整车车型")
    private String vehicleType;

    @ApiModelProperty("整车SPU")
    private String spuName;

    @ApiModelProperty("整车标配")
    private String vehicleSpecs;

    @ApiModelProperty("整车编码")
    private String mtnrv;

    @ApiModelProperty("厂家出库时间")
    private LocalDateTime factoryOutTimeS;
    private LocalDateTime factoryOutTimeE;

    @ApiModelProperty("入库时间")
    private LocalDateTime inTimeS;
    private LocalDateTime inTimeE;

    @ApiModelProperty("出库时间")
    private LocalDateTime outTimeS;
    private LocalDateTime outTimeE;

    @ApiModelProperty("产品品类")
    private String prodCategory;

    @ApiModelProperty("产品规格")
    private String prodSpecs;

    @ApiModelProperty("产地")
    private String producer;

    @ApiModelProperty("三包激活时间")
    private LocalDateTime guaranteesTimeS;
    private LocalDateTime guaranteesTimeE;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("区域")
    private String saleRegion;

    @ApiModelProperty("门店名称")
    private String salesOutletsName;

    @ApiModelProperty("车主名称")
    private String ownerName;

    @ApiModelProperty("车主联系电话")
    private String ownerMobile;

    @ApiModelProperty("车主身份证号码")
    private String idCard;

    @ApiModelProperty("车架号")
    private String vehicleNo;
}
