package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author elvis.hong
 * @title CarOwnerInfoMngParam
 * @Date  2023/2/21 16:15
 */
@Data
@ApiModel(description = "pc车主信息管理查询数据参数")
public class CarOwnerInfoMngParam extends AbstractExportQueryParam implements Serializable {

    @ApiModelProperty("唯一标识集合")
    private List<Long> idList;

    @ApiModelProperty(value = "车主ID")
    private Long carOwnerId;

    @ApiModelProperty(value = "车主姓名")
    private String userName;

    @ApiModelProperty(value = "性别")
    private Integer sex;

    @ApiModelProperty(value = "车主手机号")
    private String userPhone;

    @ApiModelProperty(value = "开始日期")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "结束日期")
    private LocalDateTime endTime;
}
