package com.elitesland.yst.production.aftersale.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title CarOwnerInfoSaveVO
 * @Date2023/2/8 11:41
 */
@Data
@ApiModel(description = "车主信息保存数据参数")
public class CarOwnerInfoParam implements Serializable {

    @ApiModelProperty(value = "车主账号")
    private Long carOwnerId;

    @ApiModelProperty(value = "车主姓名")
    private String userName;

    @ApiModelProperty(value = "车主头像")
    private String fileCode;

    @ApiModelProperty("图片filePath")
    private String url;

    @ApiModelProperty(value = "openId")
    private String openId;

    @ApiModelProperty(value = "性别 1男 0女")
    private Integer sex;

    @ApiModelProperty(value = "生日")
    private String birthdayTime;

    @ApiModelProperty(value = "城市")
    private String city;

    @ApiModelProperty(value = "职业")
    private String occupation;

    @ApiModelProperty(value = "个性签名")
    private String personalSignature;

    @ApiModelProperty(value = "车主手机号")
    private String userPhone;

}
