package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.model.param
 * @date 2023/7/17 11:45
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class CarOwnerMaintainCardPageParam extends AbstractExportQueryParam {

    @ApiModelProperty(value = "车架号")
    private String vehicleNo;

    @ApiModelProperty(value = "车主id")
    private Long carOwnerId;

    @ApiModelProperty(value = "车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty(value = "车辆颜色")
    private String vehicleColor;

    @ApiModelProperty(value = "车辆型号")
    private String vehicleType;

    @ApiModelProperty(value = "购买时间")
    private LocalDate purchaseTimeStart;

    @ApiModelProperty(value = "购买时间")
    private LocalDate purchaseTimeEnd;

    @ApiModelProperty(value = "绑定时间")
    private LocalDateTime bindingTimeStart;

    @ApiModelProperty(value = "绑定时间")
    private LocalDateTime bindingTimeEnd;


    @ApiModelProperty("车主名称")
    private String userName;


    @ApiModelProperty("车主手机号")
    private String userPhone;


    private String carName;


    private List<Long> salesOutletsIds;

    private List<Long> salesOutletsIds2;

    private Long salesOutletsId;

    @ApiModelProperty(value = "id集合")
    private List<Long> idList;

    @ApiModelProperty("门店id")
    private String salesOutletsCode;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("所属经销商")
    private String custName;

    @ApiModelProperty("所属区域名称")
    private String salesOutletsRegionName;

    @ApiModelProperty("所属区域")
    private String salesOutletsRegion;

    @ApiModelProperty("车架号or手机号")
    private String appInfo;

    @ApiModelProperty("客户名或者手机号")
    private String custInfo;

    @ApiModelProperty("电池编码")
    private String batteryCode;

    @ApiModelProperty("电充编码")
    private String chargerCode;


}
