package com.elitesland.yst.production.aftersale.model.param;

import cn.zhxu.bs.bean.DbField;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ComplaintOrderPageParam extends AbstractOrderQueryParam {

    @ApiModelProperty("唯一标识")
    private Long id;

    @ApiModelProperty("唯一标识集合")
    List<Long> idList;

    @ApiModelProperty("工单单号")
    private String orderNo;

    @ApiModelProperty("工单类型")
    private String orderType;

    @ApiModelProperty("问题类型")
    private String issueType;

    @ApiModelProperty("车主id")
    private Long carOwnerId;

    @ApiModelProperty("处理人id")
    private Long handlePersonId;

    @ApiModelProperty("联系电话")
    private String orderTel;

    @ApiModelProperty("联系人")
    private String orderPerson;

    @ApiModelProperty("处理状态")
    private String orderStatus;

    @ApiModelProperty("搜索内容")
    private String searchContent;

    @ApiModelProperty("查询来源")
    private String source;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("时效状态")
    private String timeoutStatus;

    @ApiModelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("绑定时间开始")
    private LocalDateTime bindingTimeStart;

    @ApiModelProperty("绑定时间结束")
    private LocalDateTime bindingTimeEnd;

    @ApiModelProperty("激活时间开始")
    private LocalDateTime activatTimeStart;

    @ApiModelProperty("激活时间结束")
    private LocalDateTime activatTimeEnd;

    @ApiModelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("所属经销商名称")
    private String custName;
    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof ComplaintOrderPageParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
