package com.elitesland.yst.production.aftersale.model.param;

import com.elitesland.yst.production.aftersale.model.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 客诉设置;
 * @author : http://www.chiner.pro
 * @date : 2023-2-28
 */
@Data
@ApiModel(description = "客诉设置")
public class ComplaintSetParam extends BaseModelParam {
    @ApiModelProperty("分类编码")
    private String classifyCode;

    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("客诉类型(1:C端投诉, 2:B端投诉)")
    private String complaintType;

    @ApiModelProperty("启用状态")
    private String enableFlag;

    @ApiModelProperty("最大响应时间")
    private String maxResp;

    @ApiModelProperty("最大处理时间")
    private String maxHandle;

    @ApiModelProperty("问题描述")
    private String issueDesc;

    @ApiModelProperty("序号")
    private Integer sortNo;

    @ApiModelProperty("上级id")
    private Long pid;

}