package com.elitesland.yst.production.aftersale.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;

/**
 * 工单操作日志表;
 * @author : http://www.chiner.pro
 * @date : 2023-2-17
 */
@Data
@ApiModel(description = "工单操作日志表")
public class OrderLogPageParam extends AbstractOrderQueryParam{
    @ApiModelProperty("工单id")
    private Long orderId;
    @ApiModelProperty("工单id集合")
    private List<Long> orderIdList;

    @ApiModelProperty("工单类型")
    private String orderType;

    @ApiModelProperty("操作内容")
    private String operationContent;

    @ApiModelProperty("操作时间")
    private LocalDateTime operationTime;

    @ApiModelProperty("发起者账号")
    private String operationUser;

    @ApiModelProperty("发起者账号id")
    private Long operationUserId;
}