package com.elitesland.yst.production.aftersale.model.param;

import com.elitesland.yst.production.aftersale.model.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;

import lombok.Data;
import lombok.NonNull;

/**
 * 工单操作日志表;
 * @author : http://www.chiner.pro
 * @date : 2023-2-17
 */
@Data
@ApiModel(description = "工单操作日志表")
public class OrderLogSaveParam extends BaseModelParam {
    @NonNull
    @ApiModelProperty("工单id")
    private Long orderId;

    @ApiModelProperty("工单类型")
    @NonNull
    private String orderType;

    @ApiModelProperty("指派人电话")
    private String phone;

    @NonNull
    @ApiModelProperty("操作内容")
    private String operationContent;

    @NonNull
    @ApiModelProperty("操作时间")
    private LocalDateTime operationTime;

    @NonNull
    @ApiModelProperty("发起者账号")
    private String operationUser;

    @NonNull
    @ApiModelProperty("发起者账号id")
    private Long operationUserId;
}