package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录
 */
@Data
@ApiModel(description = "电话记录")
public class PhoneRecordPageParam extends AbstractExportQueryParam {

    @ApiModelProperty("记录日期-开始")
    private LocalDateTime recordTimeStart;

     @ApiModelProperty("记录日期-结束")
     private LocalDateTime recordTimeEnd;
    @ApiModelProperty("城市编码")
    private String cityCode;
    
    @ApiModelProperty("城市名称")
    private String cityName;
    
    @ApiModelProperty("地址")
    private String addr;
    
    @ApiModelProperty("联络人")
    private String contacts;
    
    @ApiModelProperty("联系电话")
    private String contactPhone;
    
    @ApiModelProperty("客户类型")
    private String custType;
    
    @ApiModelProperty("来电类型")
    private String callType;
    
    @ApiModelProperty("来电内容")
    private String callContent;
    
    @ApiModelProperty("处理结果")
    private String processResult;
    
    @ApiModelProperty("相关部门")
    private String relevantDepartment;
    
    @ApiModelProperty("是否回访")
    private Boolean followUpFlag;
    
    @ApiModelProperty("服务满意度")
    private Integer serviceSatisfied;
    
    @ApiModelProperty("其他意见")
    private String otherOpinion;


    @ApiModelProperty("ID集合")
    private List<Long> ids;


    
}