package com.elitesland.yst.production.aftersale.model.param;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.elitesland.yst.production.aftersale.model.base.BaseModelParam;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;


 /**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录
 */
@Data
@ApiModel(description = "电话记录")
public class PhoneRecordParam extends BaseModelParam {

    @ApiModelProperty("记录日期")
    private LocalDateTime recordTime;
    
    @ApiModelProperty("城市编码")
    private String cityCode;
    
    @ApiModelProperty("城市名称")
    private String cityName;
    
    @ApiModelProperty("地址")
    private String addr;
    
    @ApiModelProperty("联络人")
    private String contacts;
    
    @ApiModelProperty("联系电话")
    private String contactPhone;
    
    @ApiModelProperty("客户类型")
    private String custType;
    
    @ApiModelProperty("来电类型")
    private String callType;

    @ApiModelProperty("下级来电类型")
    private String subCallType;
    
    @ApiModelProperty("来电内容")
    private String callContent;
    
    @ApiModelProperty("处理结果")
    private String processResult;
    
    @ApiModelProperty("相关部门")
    private String relevantDepartment;
    
    @ApiModelProperty("是否回访")
    private Boolean followUpFlag;
    
    @ApiModelProperty("服务满意度")
    private Integer serviceSatisfied;
    
    @ApiModelProperty("其他意见")
    private String otherOpinion;

     @ApiModelProperty("回访时间")
     private LocalDateTime callBackTime;
    
}