package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class PictureOrderParam extends BaseModel  implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("地址信息")
    String url;

    @ApiModelProperty("编码")
    String code;

    @ApiModelProperty("维修工单id")
    Long orderId;

    @ApiModelProperty("单据类型")
    String orderType;

    @ApiModelProperty("ES1")
    String es1;

    @ApiModelProperty("ES2")
    String es2;

    @ApiModelProperty("ES3")
    String es3;

    @ApiModelProperty("维修工单id集合")
    List<Long> orderList;




    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof PictureOrderParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
