package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class RepairOrderParam extends BaseModel  implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("id集合")
    List<Long> idList;

    @ApiModelProperty("车主信息id")
    Long personalId;

    @ApiModelProperty("车主车辆信息id")
    Long personalVehicelId;

    @ApiModelProperty("工单单号")
    String orderNo;

    @ApiModelProperty(value = "车辆来源 1-立马 0-非立马")
    Integer vehicleSource;

    @ApiModelProperty("车辆规格")
    String vehicleSpecs;

    @ApiModelProperty("车辆类型")
    String vehicleType;

    @ApiModelProperty("车辆颜色")
    String vehicleColor;

    @ApiModelProperty(value = "购买时间")
    @NotBlank(message = "购买时间不能为空")
    private LocalDate purchaseTime;

    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    @ApiModelProperty(value = "三包卡号")
    private String maintainCardNo;

    @ApiModelProperty(value = "活动编号")
    private String activityNum;

    @ApiModelProperty("问题类型")
    String questionType;

    @ApiModelProperty("维修方式")
    String repairMode;

    @ApiModelProperty("接单时间")
    LocalDateTime receiveOrderTime;

    @ApiModelProperty("完成时间")
    LocalDateTime completeTime;

    @ApiModelProperty(name = "生产日期")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("C端取消原因udc")
    private String cancelReasonC;

    @ApiModelProperty("B端取消原因udc")
    private String cancelReasonB;

    @ApiModelProperty("取消备注")
    String cancelRemark;

    @ApiModelProperty("维修备注")
    String repairRemark;

    @ApiModelProperty("维修门店id")
    Long repairStoreId;

    @ApiModelProperty("维修门店名称")
    String repairStoreName;

    @ApiModelProperty("维修门店编号")
    String repairStoreCode;

    @ApiModelProperty("联系人")
    String orderPerson;

    @ApiModelProperty("联系电话")
    String orderTel;

    @ApiModelProperty("车架号")
    String vehicleNo;

    @ApiModelProperty("问题描述")
    String questionRemark;

    @ApiModelProperty("工单状态")
    String orderStatus;

    @ApiModelProperty("上传图片集合")
    List<PictureOrderParam> pictureOrderParamList;

    @ApiModelProperty("配件")
    List<RepairPartsServiceParam> partsServiceSaveVO;

    @ApiModelProperty("统一认证中心的用户ID")
    private Long casUserId;


    @ApiModelProperty("业务员id")
    Long salesmanId;

    @ApiModelProperty("业务员")
    private String salesman;





    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairOrderParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
