package com.elitesland.yst.production.aftersale.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @Context:
 * @title: AddressInfo
 * @Author： 郑杰
 * @Date: 2023/4/14 8:27
 */
@Data
@ApiModel(description = "根据身份证号查询地址、生日、性别等信息返回参数")
public class AddressInfoVo {
    
    @ApiModelProperty("省代码")
    private String provinceCode;
    
    @ApiModelProperty("省名称")
    private String province;
    
    @ApiModelProperty("市代码")
    private String cityCode;
    
    @ApiModelProperty("市名称")
    private String city;
    
    @ApiModelProperty("车主生日")
    private LocalDate userBirthday;
    
    @ApiModelProperty("车主性别")
    private String userSex;
    
}
