package com.elitesland.yst.production.aftersale.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @Context:
 * @title: maintainCardInfoVo
 * @Author： 郑杰
 * @Date: 2023/2/21 16:50
 */
@Data
@ApiModel(description = "三包信息返回结果")
public class CarMaintainCardInfoVo implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty(name = "id")
    private Long id;


    @ApiModelProperty(name = "mountings_name")
    private String mountingsName;

    @ApiModelProperty(name = "maintain_time")
    private Double maintainTime;

    @ApiModelProperty(name = "repair_start_time")
    private LocalDate repairStartTime;

    @ApiModelProperty(name = "repair_end_time")
    private LocalDate repairEndTime;
    
    @ApiModelProperty(value = "三包内容")
    private String containThreePack;

    @ApiModelProperty(value = "非三包内容")
    private String notContainThreePack;

    @ApiModelProperty(name = "vehicle_three_pack_no")
    private Long vehicleThreePackNo;
    
    @ApiModelProperty(name = "config_id")
    private Long configId;
    
    @ApiModelProperty(name = "单位")
    private String consumerUom;

    @ApiModelProperty(name = "备注")
    private String remark;
    
}
