package com.elitesland.yst.production.aftersale.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


@Data
@ApiModel(description = "车主车辆信息信息返回数据")
public class CarOwnerVehicleVO implements Serializable {

    @ApiModelProperty(value = "车主账号", required = true)
    @NotNull(message = "车主账号不能为空")
    private Long carOwnerId;

    @ApiModelProperty(value = "车主姓名")
    private String userName;

    @ApiModelProperty(value = "车主手机号")
    @NotBlank(message = "车主手机号不能为空")
    private String userPhone;

    @ApiModelProperty(value = "车架号")
    private String vehicleNo;

    @ApiModelProperty(value = "车辆来源 1-立马 0-非立马")
    private Integer vehicleSource;

    @ApiModelProperty(value = "绑定时间")
    private String bindingTime;

    @ApiModelProperty(value = "电池编号")
    private String batteryNum;

    @ApiModelProperty(value = "销售门店名称")
    private String salesOutletsName;

    @ApiModelProperty(value = "销售门店编码")
    private String salesOutletsCode;

    @ApiModelProperty(value = "购买时间")
    @NotBlank(message = "购买时间不能为空")
    private String purchaseTime;

    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    @ApiModelProperty(value = "三包卡号")
    private String maintainCardNo;

    @ApiModelProperty(value = "车架保修期")
    private String vehicleMaintainEndTime;

    @ApiModelProperty(value = "电机保修期")
    private String machineMaintainEndTime;

    @ApiModelProperty(value = "电池保修期")
    private String batteryMaintainEndTime;

    @ApiModelProperty(value = "活动编号")
    private String activityNum;


}
