package com.elitesland.yst.production.aftersale.model.vo;


import com.el.coordinator.core.common.jpa.vo.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 工单操作日志表;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-17
 */
@ApiModel(value = "工单操作日志表", description = "")
@Data
public class OrderLogVO extends BaseModelVO {
    @ApiModelProperty("工单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long orderId;

    @ApiModelProperty("工单类型")
    private String orderType;
    private String orderTypeName;
    @ApiModelProperty("操作内容")
    private String operationContent;

    @ApiModelProperty("操作时间")
    private LocalDateTime operationTime;

    @ApiModelProperty("发起者账号")
    private String operationUser;

    @ApiModelProperty("发起者账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long operationUserId;

}