package com.elitesland.yst.production.aftersale.model.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.util.LocalDateTimeConverter;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;


/**
 * @author :
 * @date : 2023-5-10
 * @desc : 电话记录
 */
@Data
@ApiModel(description = "电话记录")
public class PhoneRecordVO extends BaseModelVO {

    @ApiModelProperty("记录日期")
    //@ExcelProperty(value = "记录日期", converter = LocalDateTimeConverter.class)
    @ExcelIgnore
    private LocalDateTime recordTime;

    @ApiModelProperty("记录日期-创建日期")
    @ExcelProperty(value = "记录时间")
    private LocalDateTime createTime;

    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("城市名称")
    @ExcelProperty("城市名称")
    private String cityName;

    @ApiModelProperty("地址")
    @ExcelProperty("地址")
    private String addr;

    @ApiModelProperty("联络人")
    @ExcelProperty("联络人")
    private String contacts;

    @ApiModelProperty("联系电话")
    @ExcelProperty("联系电话")
    private String contactPhone;

    @ApiModelProperty("客户类型")
    @SysCode(sys = "yst-after-sale", mod = "CUST_TYPE")
    private String custType;
    @ExcelProperty("客户类型")
    private String custTypeName;

    @ApiModelProperty("来电类型")
//    @SysCode(sys = "yst-after-sale", mod = "CALL_TYPE")
    private String callType;
    @ExcelProperty("来电类型")
    private String callTypeName;

    @ExcelProperty("下级来电类型")
    private String subCallType;
    @ExcelProperty("下级来电类型")
    private String subCallTypeName;

    @ApiModelProperty("来电内容")
    @ExcelProperty("来电内容")
    private String callContent;

    @ApiModelProperty("处理结果")
    @ExcelProperty("处理结果")
    private String processResult;

    @ApiModelProperty("相关部门")
    @ExcelProperty("相关部门")
    private String relevantDepartment;

    @ApiModelProperty("是否回访")
    private Boolean followUpFlag;
    @ExcelProperty("是否回访")
    private String followUpFlagName;

    @ApiModelProperty("回访时间")
    @ExcelProperty("回访时间")
    private LocalDateTime callBackTime;

    @ApiModelProperty("服务满意度")
    private Integer serviceSatisfied;
    @ExcelProperty("服务满意度")
    private String serviceSatisfiedName;

    @ApiModelProperty("其他意见")
    @ExcelProperty("其他意见")
    private String otherOpinion;

    @ApiModelProperty("记录人")
    private String createName;
}