package com.elitesland.yst.production.aftersale.model.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;



@Data
public class RepairOrderVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    //导出数据
    @ApiModelProperty("车主信息id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long personalId;

    @ApiModelProperty("车主车辆信息id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long personalVehicelId;

    @ApiModelProperty("工单单号")
    @ExcelProperty("工单单号")
    String orderNo;

    @ApiModelProperty("车辆类型")
    @ExcelProperty("车辆类型")
    String vehicleType;

    @ApiModelProperty("车架号")
    @ExcelProperty("车架号")
    String vehicleNo;

    @ApiModelProperty("工单状态")
    @SysCode(sys = "yst-after-sale", mod = "REPAIR_ORDER")
    String orderStatus;
    String orderStatusName;

    @ApiModelProperty("维修方式")
    String repairMode;
    String repairModeName;

    @ApiModelProperty("联系人")
    @ExcelProperty("客户姓名")
    String orderPerson;

    @ApiModelProperty("联系电话")
    @ExcelProperty("客户手机号")
    String orderTel;

    @CreatedDate
    private LocalDateTime createTime;

    @ApiModelProperty("创建人")
    private String creator;


    @ApiModelProperty("接单时间")
    LocalDateTime receiveOrderTime;

    @ApiModelProperty("完成时间")
    LocalDateTime completeTime;

    @ApiModelProperty("C端取消原因udc")
    @SysCode(sys = "yst-after-sale", mod = "CANCEL_REASON_C")
    private String cancelReasonC;
    private String cancelReasonCName;

    @ApiModelProperty("B端取消原因udc")
    @SysCode(sys = "yst-after-sale", mod = "CANCEL_REASON_B")
    private String cancelReasonB;
    private String cancelReasonBName;

    @ApiModelProperty("取消备注")
    String cancelRemark;

    @ApiModelProperty("维修门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long repairStoreId;

    @ApiModelProperty("维修门店名称")
    @ExcelProperty("所属门店")
    String repairStoreName;

    @ApiModelProperty("维修门店编码")
    String repairStoreCode;

    @ApiModelProperty("购买时间")
    LocalDate purchaseTime;

    @ApiModelProperty("购买门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long purchaseStoreId;

    @ApiModelProperty("购买门店")
    String purchaseStoreName;

    @ApiModelProperty("购买门店编码")
    String purchaseStoreCode;

    @ApiModelProperty("问题类型")
    String questionType;

    @ApiModelProperty("问题描述")
    @ExcelProperty("问题描述")
    String questionRemark;
    @ApiModelProperty("车主车辆信息")
    BindSoldVehicleVO bindSoldVehicleVO;

    @ApiModelProperty("门店信息")
    StoreVO storeVO;

    @ApiModelProperty("评价工单信息")
    OrderEvaluationVO orderEvaluationVO;

    @ApiModelProperty("图片信息")
    List<PictureOrderVO> pictureOrderVOS;
    @ApiModelProperty("配件服务信息")
    List<RepairPartsServiceVO> repairPartsServiceVOS;
    @ApiModelProperty("工单日志")
    List<OrderLogVO> orderLogVOS;

    @ApiModelProperty("服务项目")
    @SysCode(sys = "yst-after-sale", mod = "SERVICE_ITEM")
    private Integer serviceType;
    private String serviceTypeName;

    @ApiModelProperty("车辆来源")
    private Integer vehicleSource;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("业务员id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long salesmanId;

    @ApiModelProperty("业务员")
    String salesman;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @CreatedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;



    @LastModifiedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty(value = "修改人")
    private String updater;

    @ApiModelProperty("维修备注")
    private String repairRemark;



    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;

    @ApiModelProperty("操作人姓名")
    private String operUserName;



    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("配件(服务)名称")
    @ExcelProperty("配件(服务)名称")
    private String repairPartName;

    @ApiModelProperty("类型")
    @ExcelProperty("类型")
    private String repairPartType;

    @ApiModelProperty("配件单价")
    @ExcelProperty("配件单价")
    BigDecimal partsPrice;

    @ApiModelProperty("服务价格")
    @ExcelProperty("服务价格")
    BigDecimal servicePrice;

    @LastModifiedDate
    @ApiModelProperty("更新时间")
    @ExcelProperty("更新时间")
    private LocalDateTime modifyTime;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairOrderVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
