package com.elitesland.yst.production.aftersale.model.vo;

import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class StoreVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("门店名称")
    String storeName;
    @ApiModelProperty("门店编号")
    String storeCode;
    @ApiModelProperty("营业时间")
    LocalDateTime businessTime;

    @ApiModelProperty("地址")
    String url;
    @ApiModelProperty("服务类型")
    List<String> serviceTypes;

    @ApiModelProperty("电话")
    String tel;
    @ApiModelProperty("门店距离")
    String storeDistance;

    @ApiModelProperty("维度")
    Double latitude;

    @ApiModelProperty("经度")
    Double longitude;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区县")
    private String county;



    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof StoreVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
