package com.elitesland.yst.production.aftersale.model.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@Data
@ApiModel("新增分类参数")
public class PhoneRecClsSaveVO implements Serializable {

    /** 分类类别 */
    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "分类编码")
    private String code;

    /** 分类名称 */
    @Size(max = 255, message = "分类名称最多允许255个字符")
    @NotBlank(message = "分类名称不允许为空")
    @ApiModelProperty(value = "分类名称")
    private String name;

    /** 简介 */
    @Size(max = 1000, message = "简介描述最多允许1000个字符")
    @ApiModelProperty(value = "简介描述")
    private String descr;

    /**排序号*/
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    /**上级ID*/
    @NotNull(message = "上级ID不允许为空")
    @ApiModelProperty(value = "上级ID")
    private Long pid = 0L;
}
