package com.elitesland.yst.production.aftersale.out.sale;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.rpc.LmCustRpcService;
import com.elitesland.yst.production.sale.rpc.param.SalesmanStoreDTO;
import com.elitesland.yst.production.sale.service.CrmCustRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
@Slf4j
public class CrmSaleServiceImpl implements CrmSaleService {
    private final LmCustRpcService lmCustRpcService;
    private final CrmCustRpcService crmCustRpcService;


    @Override
    public CrmCustSimpleVO getCustSimple(Long userId) {
        log.info("查询客户信息入参：{}"+ JSON.toJSONString(userId));
        try {
            CrmCustSimpleVO custSimple = lmCustRpcService.getCustSimpleByUserId(userId);
            log.info("查询客户信息结果：{}"+ JSON.toJSONString(custSimple));
            return custSimple;
        } catch (Exception e) {
            log.error("getCustSimple error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询客户信息入参"+e.getMessage());
        }
    }

    @Override
    public CrmCustSimpleVO bcGetCustSimple(String userName) {
        log.info("查询客户信息入参：{}"+ JSON.toJSONString(userName));
        try {
            CrmCustSimpleVO custSimple = crmCustRpcService.getCustSimple(userName);
            log.info("查询客户信息结果：{}"+ JSON.toJSONString(custSimple));
            return custSimple;
        } catch (Exception e) {
            log.error("getCustSimple error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询客户信息入参"+e.getMessage());
        }
    }

    @Override
    public List<CrmCustRespDTO> getCustByParam(CrmCustRpcDtoParam crmCustRpcDtoParam) {
        log.info("getCustByParam查询客户信息入参：{}"+ JSON.toJSONString(crmCustRpcDtoParam));
        try {
            ApiResult<List<CrmCustRespDTO>> custByParam = crmCustRpcService.getCustByParam(crmCustRpcDtoParam);
            log.info("getCustByParam查询客户信息结果：{}"+ JSON.toJSONString(custByParam.getData()));
            return custByParam.getData();
        } catch (Exception e) {
            log.error("getCustByParam error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "getCustByParam查询客户信息入参"+e.getMessage());
        }
    }

    @Override
    public List<CustCode2BaseDTO> getCustByCustCode2(CustCode2BaseParam custCode2BaseParam) {
        log.info("getCustByCustCode2查询客户信息入参：{}"+ JSON.toJSONString(custCode2BaseParam));
        try {
            ApiResult<List<CustCode2BaseDTO>> custByParam = crmCustRpcService.getByCust2Base(custCode2BaseParam);
            log.info("getCustByCustCode2查询客户信息结果：{}"+ JSON.toJSONString(custByParam.getData()));
            return custByParam.getData();
        } catch (Exception e) {
            log.error("getCustByCustCode2 error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "getCustByCustCode2查询客户信息入参"+e.getMessage());
        }
    }

    @Override
    public ApiResult<List<SalesmanLevelInfoDTO>> queryLevelInfos(List<Long> ids) {
        log.info("queryLevelInfo查询业务员信息入参：{}"+ JSON.toJSONString(ids));
        try {
            ApiResult<List<SalesmanLevelInfoDTO>> listApiResult = crmCustRpcService.queryLevelInfos(ids);
            log.info("queryLevelInfo查询客户信息结果：{}"+ JSON.toJSONString(listApiResult));
            return listApiResult;
        } catch (Exception e) {
            log.error("queryLevelInfo error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "queryLevelInfo查询客户信息入参"+e.getMessage());
        }
    }


    @Override
    public List<Long> querySaleManStoreIds(String empCode) {
        log.info("querySaleManStoreIds查询业务员门店信息入参：{}"+ empCode);
        try {
            List<SalesmanStoreDTO> saleManStoreList = lmCustRpcService.querySalesmanStore(empCode);
            log.info("queryLevelInfo查询客户信息结果：{}"+ JSON.toJSONString(saleManStoreList));
            saleManStoreList = saleManStoreList.stream().filter(x -> !CollectionUtils.isEmpty(x.getId())).collect(Collectors.toList());
            List<Long> idList = new ArrayList<>();
            for (SalesmanStoreDTO x : saleManStoreList) {
                idList.addAll(x.getId());
            }
            return idList;
        } catch (Exception e) {
            log.error("querySaleManStoreIds error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "querySaleManStoreIds查询业务员门店信息入参"+e.getMessage());
        }
    }

}
