package com.elitesland.yst.production.aftersale.out.support;


import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class OrgStoreServiceImpl implements OrgStoreService {
    private final OrgStoreRpcService orgStoreRpcService;


    @Override
    public OrgStoreDetailRpcDTO orgStoreGet(Long id) {
        log.info("orgStoreGet：{}"+ JSON.toJSONString(id));
        try {
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreRpcService.get(id);
            return orgStoreDetailRpcDTO;
        } catch (Exception e) {
            log.error("orgStoreGet error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询门店信息失败"+e.getMessage());
        }
    }

    @Override
    public OrgStoreDetailRpcDTO getByCode(String storeCode) {
        log.info("getByCode：{}"+ JSON.toJSONString(storeCode));
        try {
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreRpcService.getByCode(storeCode);
            return orgStoreDetailRpcDTO;
        } catch (Exception e) {
            log.error("orgStoreGet error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询门店信息失败"+e.getMessage());
        }
    }

    @Override
    public List<OrgStoreDetailRpcDTO> queryByIds(List<Long> ids) {
        log.info("queryByIds：{}"+ JSON.toJSONString(ids));
        try {
            List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = orgStoreRpcService.queryByIds(ids);
            return orgStoreDetailRpcDTOS;
        } catch (Exception e) {
            log.error("queryByIds error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询门店信息失败"+e.getMessage());
        }
    }
}
