package com.elitesland.yst.production.aftersale.out.support.lm;

import cn.hutool.json.JSONUtil;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;


import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import com.elitesland.yst.production.support.provider.store.param.ItmOrgStoreRpcDtoParam;
import com.elitesland.yst.production.support.provider.store.service.OrgStoreRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class OrgStoreLmServiceImpl implements OrgStoreLmService {
    private final OrgStoreRpcService orgStoreRpcService;


    /**
     * 根据公司编码查询门店信息（一对多）
     *
     * @param ouCode
     * @return
     */
    @Override
    public List<OrgStoreRpcDTO> orgStoreGet(String ouCode) {
        log.info("根据公司编码查询门店信息入参：{}" + JSON.toJSONString(ouCode));
        try {
            ItmOrgStoreRpcDtoParam itmOrgStoreRpcDtoParam = new ItmOrgStoreRpcDtoParam();
            itmOrgStoreRpcDtoParam.setOuCode(ouCode);
            ApiResult<List<OrgStoreRpcDTO>> listApiResult = orgStoreRpcService.queryStoreMsg(itmOrgStoreRpcDtoParam);
            if (listApiResult.isSuccess()) {
                log.info("根据公司编码查询门店信息结果：{}" + JSON.toJSONString(listApiResult.getData()));
                return listApiResult.getData();
            }
            return new ArrayList<>();
        } catch (Exception e) {
            log.error("orgStoreGet error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "根据公司编码查询门店信息失败" + e.getMessage());
        }
    }
}
