package com.elitesland.yst.production.aftersale.provider.sale;


import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.rpc.VinOrderRpcService;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.sale.rpc.param.query.ProdOrderVehicleRpcParam;
import com.elitesland.yst.production.order.rpc.LmSaleDoRpcService;
import com.elitesland.yst.production.order.rpc.param.resp.VehicleNoInfoVO;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.sale
 * @date 2023/4/1 14:01
 */
@Component
@Log4j2
public class VinOrderRpcProvider {

    @Autowired
    private VinOrderRpcService vinOrderRpcService;

    @Autowired
    private LmSaleDoRpcService lmSaleDoRpcService;


    public VinOrderRpcDTO getByVinNo(String vinNo) {

        VinOrderRpcDTO vinOrderRpcDTO = null;

        try {
            VehicleNoInfoVO vehicleNoInfoVO = lmSaleDoRpcService.queryVehicleNoInfo(vinNo);
            if(null != vehicleNoInfoVO) {
                vinOrderRpcDTO = new VinOrderRpcDTO();
                vinOrderRpcDTO.setVinNo(vehicleNoInfoVO.getVehicleNo());
                vinOrderRpcDTO.setMtnrv(vehicleNoInfoVO.getItemCode());
                vinOrderRpcDTO.setId(vehicleNoInfoVO.getItemId());
            }
        } catch (Exception e) {
            log.error("调用order失败:" + e.getMessage());
        }

        if(null == vinOrderRpcDTO){
            try {
                vinOrderRpcDTO = vinOrderRpcService.getByVinNo(vinNo);
            } catch (Exception e) {
                throw new BusinessException("调用sale失败:" + e.getMessage());
            }
        }

        if (null == vinOrderRpcDTO) {
            throw new BusinessException("车架号未关联到商品信息：" + vinNo + ",请联系业务主管");
        }
        if (StringUtils.isEmpty(vinOrderRpcDTO.getMtnrv())) {
            throw new BusinessException("车架号关联商品信息,库存物料(商品编码为空");
        }
        return vinOrderRpcDTO;
    }
    public List<VinOrderRpcDTO> getByVinNos(List<String> vinNo) {
        ProdOrderVehicleRpcParam param = new ProdOrderVehicleRpcParam();
        param.setVinNoList(vinNo);
        List<VinOrderRpcDTO> vinOrderRpcDTO = null;
        try {
            vinOrderRpcDTO = vinOrderRpcService.queryVehicles(param);
        } catch (Exception e) {
            log.error("调用sale失败:" + e.getMessage());
        }

//        if(null == vinOrderRpcDTO){
//            try {
//                VehicleNoInfoVO vehicleNoInfoVO = lmSaleDoRpcService.queryVehicleNoInfo(vinNo);
//                if(null != vehicleNoInfoVO) {
//                    vinOrderRpcDTO = new VinOrderRpcDTO();
//                    vinOrderRpcDTO.setVinNo(vehicleNoInfoVO.getVehicleNo());
//                    vinOrderRpcDTO.setMtnrv(vehicleNoInfoVO.getItemCode());
//                    vinOrderRpcDTO.setId(vehicleNoInfoVO.getItemId());
//                }
//            } catch (Exception e) {
//                throw new BusinessException("调用order失败:" + e.getMessage());
//            }
//        }
//
//        if (null == vinOrderRpcDTO) {
//            throw new BusinessException("车架号未关联到商品信息：" + vinNo + ",请联系业务主管");
//        }
//        if (StringUtils.isEmpty(vinOrderRpcDTO.getMtnrv())) {
//            throw new BusinessException("车架号关联商品信息,库存物料(商品编码为空");
//        }
        return vinOrderRpcDTO;
    }

}
