package com.elitesland.yst.production.aftersale.provider.support;

import cn.hutool.core.collection.CollUtil;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.price.dto.ItmWarrantyConfigRpcDTO;
import com.elitesland.yst.production.support.provider.price.param.ItmWarrantyConfigRpcQueryParam;
import com.elitesland.yst.production.support.provider.price.service.ItmWarrantyConfigRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.support
 * @date 2023/4/1 14:37
 */

@Component
@Log4j2
public class ItmWarrantyConfigRpcProvider {

    @Autowired
    private ItmWarrantyConfigRpcService itmWarrantyConfigRpcService;


    public List<ItmWarrantyConfigRpcDTO> getConfig(ItmWarrantyConfigRpcQueryParam itmWarrantyConfigRpcQueryParam) {
        List<ItmWarrantyConfigRpcDTO> config = null;
        try {
            config = itmWarrantyConfigRpcService.getConfig(new ItmWarrantyConfigRpcQueryParam());
        } catch (Exception e) {
            throw new BusinessException("调用sale域失败:" + e.getMessage());
        }
        if (CollUtil.isEmpty(config)) {
            throw new BusinessException("调用sale域失败:获取数据为空");
        }
        return config;
    }

}

