package com.elitesland.yst.production.aftersale.provider.support;

import cn.hutool.core.collection.CollUtil;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.item.dto.LmItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcParam;
import com.elitesland.yst.production.support.provider.item.service.LmItmItemRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.support
 * @date 2023/4/1 13:51
 */
@Component
@Log4j2
public class LmItmItemRpcProvider {

    @Autowired
    private LmItmItemRpcService lmItmItemRpcService;


    public List<LmItmItemRpcDTO> findSkuByParam(ItmItemRpcParam itmItemRpcParam) {

        List<LmItmItemRpcDTO> skuByParam = null;
        try {
            skuByParam = lmItmItemRpcService.findSkuByParam(itmItemRpcParam);
        } catch (Exception e) {
            throw new BusinessException("调用support域失败:" + e.getMessage());
        }
//        if (CollUtil.isEmpty(skuByParam)) {
//            throw new BusinessException("调用support域失败: 未查询到车辆属性信息");
//        }
        return skuByParam;
    }

}

