package com.elitesland.yst.production.aftersale.provider.support;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.store.service.OrgStoreRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/8/7 11:45
 */
@Component
@Log4j2
public class OrgStoreRpcProvider {
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    public List<OrgStoreDetailRpcDTO> queryByStoreCodes(@RequestBody List<String> storeCodes) {
        List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS=new ArrayList<>();
        try {
             orgStoreDetailRpcDTOS = orgStoreRpcService.queryByStoreCodes(storeCodes);
        } catch (Exception e) {
            throw new BusinessException("调用support域失败:" + e.getMessage());
        }
        return orgStoreDetailRpcDTOS;
    }
}
