package com.elitesland.yst.production.aftersale.provider.system;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.system
 * @date 2023/6/7 13:19
 */
@Component
@Log4j2
public class SysUserPermissionRpcProvider {

    @Autowired
    private SysUserPermissionRpcService sysUserPermissionRpcService;


    /**
     *根据角色编码查询该角色下的userid
     * @param roleCode
     * @return
     */
    public Set<Long> getUserIdByRoleCode(String roleCode) {

        ApiResult<Set<Long>> apiResult = null;
        try {
            apiResult = sysUserPermissionRpcService.getUserIdByRoleCode(roleCode);
        } catch (Exception e) {
            log.error(e);
            throw new BusinessException("调用system域失败:" + e.getMessage());
        }
        if (apiResult.getCode() != ApiCode.SUCCESS.getCode()) {
            throw new BusinessException("调用system域失败:" + apiResult.getMsg());
        }
        return apiResult.getData();

    }

}


