package com.elitesland.yst.production.aftersale.provider.system;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.system.provider.extend.SysThirdPartyAccountRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.system
 * @date 2023/3/31 13:50
 */
@Component
@Log4j2
public class SystemRpcProvider {

    @Autowired
    private SysThirdPartyAccountRpcService accountRpcService;


    public Long getTenantIdByAccount(String wechatAppId) {
        ApiResult<Long> accountResult = null;
        try {
            accountResult = accountRpcService.getTenantIdByAccount(wechatAppId);
        } catch (Exception e) {
            log.error(e);
            throw new BusinessException("调用system域失败:" + e.getMessage());
        }
        if (accountResult.getCode() != ApiCode.SUCCESS.getCode()) {
            throw new BusinessException("调用system域失败:" + accountResult.getMsg());
        }
        if (accountResult.getData() == null) {
            log.error("获取小程序{}所属租户失败：{}", wechatAppId, accountResult.getMsg());
            throw new BusinessException("获取system域小程序配置失败:空");
        }
        return accountResult.getData();
    }

}

