package com.elitesland.yst.production.aftersale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleDTO;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleRespDTO;
import com.elitesland.yst.production.aftersale.dto.LmSaleLinkDTO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.TemTransmissionLogDO;
import com.elitesland.yst.production.aftersale.model.param.TemTransmissionLogParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.out.support.OrgStoreService;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.support.LmItmItemRpcProvider;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.util.ConstantsAfterSale;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.LmItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

/**
 * ClassName: AfterSaleRpcServiceImpl
 * Description:
 *
 * @author wz
 * @date 2023/5/19 13:27
 */
@Slf4j
@RestController
@RequestMapping(AfterSaleRpcService.URI)
public class AfterSaleRpcServiceImpl implements AfterSaleRpcService {
    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;
    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    @Autowired
    private TemTransmissionLogService temporalLogService;
    @Autowired
    private OrgStoreService orgStoreService;

    @Autowired
    private CarMaintainCardService carMaintainCardService;
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;
    @Autowired
    private LmItmItemRpcProvider lmItmItemRpcProvider;
    @Autowired
    private VinOrderRpcProvider vinOrderRpcProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmSaleService crmSaleService;

    private final String DOC_TYPE = "store";

    /**
     * 1.查询前一天绑车激活数量：按照激活时间+激活标识+立马标识 查询前一天的绑车激活数量
     * 2.查询前一天激活解绑数量（绑车不激活的解绑车辆不统计）：按照修改时间+激活标识+delete_flag=1+立马标识
     * 3.查询门店，客户信息，(之前的门店有一个问题：门店更新全删全查，所以门店更新后历史数据的门店id无法使用，现在门店更新不更改门店id，新数据没有此问题)
     * 4.数据分组：区域udc编码+门店编码+客户编码+业务员层级关系路径Salesman_path +车型udc编码
     * 5.组装数据返回给销售域调用方
     * @param afterSaleVehicleDTO
     * @return
     */
    @Override
    public ApiResult<List<AfterSaleVehicleRespDTO>> queryVehicle(AfterSaleVehicleDTO afterSaleVehicleDTO) {
        List<AfterSaleVehicleRespDTO> dtoList = new ArrayList<>();
        List<String> remarkList = new ArrayList<>();
        List<CarOwnerVehicleInfoDO> vehicleInfoDOList = new ArrayList<>();
        log.info("开始统计业务员绑定车辆数据:" + JSON.toJSONString(afterSaleVehicleDTO));
        //获取当前时间，前一天的开始时间
        afterSaleVehicleDTO.setStartTime(afterSaleVehicleDTO.getStartTime() == null ? LocalDateTime.of(LocalDate.now().minusDays(1), LocalTime.MIN) : afterSaleVehicleDTO.getStartTime());
        //获取当前时间，前一天的结束时间
        afterSaleVehicleDTO.setEndTime(afterSaleVehicleDTO.getEndTime() == null ? LocalDateTime.of(LocalDate.now().minusDays(1), ConstantsAfterSale.LOCAL_TIME_MAX) : afterSaleVehicleDTO.getEndTime());
        //查询当前绑车数量
//        List<CarOwnerVehicleInfoDO> byBindingTimeBetween = carOwnerVehicleRepo.findByBindingTimeBetween(afterSaleVehicleDTO.getStartTime(), afterSaleVehicleDTO.getEndTime(),1,1);
//        //查询当天解绑数量
//        List<CarOwnerVehicleInfoDO> delBindingVehicleCount = carOwnerVehicleRepo.findByModifTimeBetween(afterSaleVehicleDTO.getStartTime(), afterSaleVehicleDTO.getEndTime(),1,1,1);
        // 改取激活表的数据
        List<CarMaintainCardDO> activeList = carMaintainCardRepo.findByCreateTimeBetween(afterSaleVehicleDTO.getStartTime(), afterSaleVehicleDTO.getEndTime());
        List<CarMaintainCardDO> cancelList = carMaintainCardRepo.findByModifyTimeBetween(afterSaleVehicleDTO.getStartTime(), afterSaleVehicleDTO.getEndTime());
        if (CollUtil.isNotEmpty(activeList)) {
            List<CarOwnerVehicleInfoDO> carOwnerVehicleInfoS = buildData(activeList);
            vehicleInfoDOList.addAll(carOwnerVehicleInfoS);
        }
        if (CollUtil.isNotEmpty(cancelList)) {
            List<CarOwnerVehicleInfoDO> carOwnerVehicleInfoDOS = buildData(cancelList);
            vehicleInfoDOList.addAll(carOwnerVehicleInfoDOS);
        }
        //汇总绑车数据
//        vehicleInfoDOList.addAll(byBindingTimeBetween);
//        vehicleInfoDOList.addAll(delBindingVehicleCount);


        //没有查询到数据直接返回
        if (CollectionUtils.isEmpty(vehicleInfoDOList)) {
            return ApiResult.ok(dtoList);
        }
        log.info("绑车数据查询:{}" + vehicleInfoDOList);
        //根据门店编码批量查询门店，返回 经营性质，门店详细地址字段，
        Map<Long, List<OrgStoreDetailRpcDTO>> stringListMap = this.storeQuery(vehicleInfoDOList);
        //处理车型字段
        vehicleInfoDOList.stream().forEach(t -> {
            if (StringUtils.isNotEmpty(t.getVehicleType()) && t.getVehicleType().contains("/")) {
                t.setVehicleType(Arrays.stream(t.getVehicleType().split("/")).findFirst().get());
            }
        });

        log.info("门店查询数据:{}" + stringListMap);
        //分组：区域udc编码+门店编码+客户编码+业务员层级关系路径Salesman_path +车型udc编码
        //门店编码为空的过滤掉
        Map<String, List<CarOwnerVehicleInfoDO>> collect = vehicleInfoDOList.stream().filter(t ->t.getSalesOutletsId() != null ).collect(Collectors.groupingBy(o ->
                o.getSalesOutletsRegionName() + "_" + o.getSalesOutletsCode() + "_" + o.getCustCode() + "_" + o.getSalesmanName()+ "_" + o.getItemType3() + "_" + o.getVehicleType()));

        //数据组装
        List<Long> activatList = activeList.stream().map(CarMaintainCardDO::getId).collect(Collectors.toList());
        List<Long> deleteList = cancelList.stream().map(CarMaintainCardDO::getId).collect(Collectors.toList());
        collect.keySet().forEach(t -> {
            long countOne = 0;
            long countTwo = 0;
            AfterSaleVehicleRespDTO respDTO = new AfterSaleVehicleRespDTO();
            CarOwnerVehicleInfoDO statisticsVO = collect.get(t).get(0);

            if(!CollectionUtils.isEmpty(activatList)){
                countOne = collect.get(t).stream().filter(v ->activatList.contains(v.getId())).count();
            }
            if(!CollectionUtils.isEmpty(deleteList)){
                countTwo = collect.get(t).stream().filter(v ->deleteList.contains(v.getId())).count();
            }

            respDTO.setCustCode(statisticsVO.getCustCode());
            respDTO.setCustCode2(statisticsVO.getCustCode2());
            respDTO.setCustName(statisticsVO.getCustName());
            respDTO.setRegion(statisticsVO.getSalesOutletsRegion());
            respDTO.setSalesmanPath(statisticsVO.getSalesmanName());
            respDTO.setItemType3(statisticsVO.getItemType3());
            respDTO.setItemType5(statisticsVO.getVehicleType());
            respDTO.setShipQty(BigDecimal.valueOf(countOne - countTwo));
            respDTO.setDocTime(afterSaleVehicleDTO.getStartTime());
            if(MapUtil.isNotEmpty(stringListMap) && statisticsVO.getSalesOutletsId() != null ) {
                List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = stringListMap.get(statisticsVO.getSalesOutletsId());
                if(!CollectionUtils.isEmpty(orgStoreDetailRpcDTOS)){
                    OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreDetailRpcDTOS.get(0);
                    if(Objects.nonNull(orgStoreDetailRpcDTO)){
                        respDTO.setStoreType2(orgStoreDetailRpcDTO.getStoreType2());
                        respDTO.setStoreCode(orgStoreDetailRpcDTO.getStoreCode());
                        respDTO.setStoreName(orgStoreDetailRpcDTO.getStoreName());
                        if(!Objects.isNull(orgStoreDetailRpcDTO.getAddressRpcDTO())){
                            respDTO.setDetailAddr(Objects.isNull(orgStoreDetailRpcDTO.getAddressRpcDTO()) ? null : orgStoreDetailRpcDTO.getAddressRpcDTO().getDetailAddr());
                        }
                    }
                }else{
                    String remark = "无门店: "+statisticsVO.getSalesOutletsId();
                    remarkList.add(remark);
                }
            }
            dtoList.add(respDTO);
        });
        log.info("结束统计业务员绑定车辆数据:{}" + dtoList);

        // add logs
        CompletableFuture<TemTransmissionLogDO> objectCompletableFuture = CompletableFuture.supplyAsync(() -> {

//            System.out.println(Thread.currentThread().getName());
            TemTransmissionLogParam param = new TemTransmissionLogParam();
            param.setDealFlag(true);
            param.setFromStr(JSON.toJSONString(afterSaleVehicleDTO));
            param.setRetNum(Long.valueOf(dtoList.size()));
            param.setSourcePlatform("sale");
            param.setRetStr(JSON.toJSONString(dtoList));
            param.setRemark(CollectionUtils.isEmpty(remarkList) ? null : JSON.toJSONString(remarkList));
            TemTransmissionLogDO res;
            res = temporalLogService.save(param);
            return res;
        });
        try {
            TemTransmissionLogDO temTransmissionLogDO = objectCompletableFuture.get();
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }


        return ApiResult.ok(dtoList);
    }

    private List<CarOwnerVehicleInfoDO> buildData(List<CarMaintainCardDO> list) {
        List<CarOwnerVehicleInfoVO> allByStoreCode = carOwnerVehicleRepoProc.findAllByStoreCode(list.stream().map(CarMaintainCardDO::getSalesOutletsCode).collect(Collectors.toList()));
        Map<String, String> salesmanMap = allByStoreCode.stream().filter(x->StringUtils.isNotEmpty(x.getSalesOutletsCode())).filter(x->StringUtils.isNotEmpty(x.getSalesmanName())).collect(Collectors.toMap(CarOwnerVehicleInfoVO::getSalesOutletsCode, CarOwnerVehicleInfoVO::getSalesmanName, (v1, v2) -> v1));
        Map<String, String> regionMap = userService.sysUdcGetCodeMap("yst-supp", "REGION");
        List<String> vinList = list.stream().map(CarMaintainCardDO::getVehicleNo).collect(Collectors.toList());
        List<VinOrderRpcDTO> vinOrderRpcDTOS = vinOrderRpcProvider.getByVinNos(vinList);
        CustCode2BaseParam code2BaseParam = new CustCode2BaseParam();
        code2BaseParam.setCustCode2(list.stream().map(CarMaintainCardDO::getCustCode2).collect(Collectors.toList()));
        List<CustCode2BaseDTO> custBaseInfo = crmSaleService.getCustByCustCode2(code2BaseParam);
        Map<String, LmItmItemRpcDTO> itemMap = new HashMap<>();
        Map<String, VinOrderRpcDTO> vinNoMap = new HashMap<>();
        Map<String, String> custMap = new HashMap<>();
        if (CollUtil.isNotEmpty(vinOrderRpcDTOS)) {
            vinNoMap = vinOrderRpcDTOS.stream().collect(Collectors.toMap(VinOrderRpcDTO::getVinNo, t -> t, (v1, v2) -> v1));
            List<String> itemCodes = vinOrderRpcDTOS.stream().map(VinOrderRpcDTO::getMtnrv).collect(Collectors.toList());
            ItmItemRpcParam param = new ItmItemRpcParam();
            param.setItemCodes(itemCodes);
            List<LmItmItemRpcDTO> itmItemRpcDTOS = lmItmItemRpcProvider.findSkuByParam(param);
            if (CollUtil.isNotEmpty(itmItemRpcDTOS)) {
                itemMap = itmItemRpcDTOS.stream().collect(Collectors.toMap(LmItmItemRpcDTO::getItemCode, t -> t, (v1, v2) -> v1));
            }
        }
        if (CollUtil.isNotEmpty(custBaseInfo)) {
            custMap = custBaseInfo.stream().collect(Collectors.toMap(CustCode2BaseDTO::getCustCode2, CustCode2BaseDTO::getCustCode, (v1, v2) -> v1));
        }
        Map<String, LmItmItemRpcDTO> finalItemMap = itemMap;
        Map<String, VinOrderRpcDTO> finalVinNoMap = vinNoMap;
        Map<String, String> finalCustMap = custMap;
        List<CarOwnerVehicleInfoDO> carOwnerVehicleInfoDOList = list.stream().map(x -> {
            CarOwnerVehicleInfoDO infoDO = new CarOwnerVehicleInfoDO();
            infoDO.setCustName(x.getCustName());
            infoDO.setId(x.getId());
            infoDO.setSalesOutletsRegion(x.getRegion());
            infoDO.setSalesOutletsRegionName(regionMap.get(x.getRegion()));
            infoDO.setCustCode2(x.getCustCode2());
            if (CollUtil.isNotEmpty(finalCustMap) && finalCustMap.containsKey(x.getCustCode2())) {
                infoDO.setCustCode(finalCustMap.get(x.getCustCode2()));
            }
            infoDO.setSalesOutletsId(x.getSalesOutletsId());
            infoDO.setVehicleType(x.getVehicleType());
            infoDO.setSalesOutletsCode(x.getSalesOutletsCode());
            if (CollUtil.isNotEmpty(finalVinNoMap) && finalVinNoMap.containsKey(x.getVehicleNo())) {
                VinOrderRpcDTO vinOrderRpcDTO = finalVinNoMap.get(x.getVehicleNo());
                if (CollUtil.isNotEmpty(finalItemMap) && finalItemMap.containsKey(vinOrderRpcDTO.getMtnrv())) {
                    LmItmItemRpcDTO lmItmItemRpcDTO = finalItemMap.get(vinOrderRpcDTO.getMtnrv());
                    infoDO.setItemType3(lmItmItemRpcDTO.getItemType3());
                } else {
                    infoDO.setItemType3("230");
                }

            }
            if (CollUtil.isNotEmpty(salesmanMap) && salesmanMap.containsKey(x.getSalesOutletsCode())) {
                infoDO.setSalesmanName(salesmanMap.get(x.getSalesOutletsCode()));
            } else {
                infoDO.setSalesmanName("");
            }
            return infoDO;
        }).collect(Collectors.toList());
        return carOwnerVehicleInfoDOList;
    }


    /**
     * 批量查询门店
     * @param vehicleInfoDOS
     */
    public Map<Long, List<OrgStoreDetailRpcDTO>> storeQuery(List<CarOwnerVehicleInfoDO> vehicleInfoDOS) {
        List<Long> collect = vehicleInfoDOS.stream().filter(t -> t.getSalesOutletsId() != null).map(CarOwnerVehicleInfoDO::getSalesOutletsId).collect(Collectors.toList());
        Map<Long, List<OrgStoreDetailRpcDTO>> storeMap = orgStoreService.queryByIds(collect).stream()
                .collect(Collectors.groupingBy(OrgStoreDetailRpcDTO::getId));

        return storeMap;
    }

    @Override
    public ApiResult<List<LmSaleLinkDTO>> queryVehicleTypeByItemType5(String itemType5) {
        List<CarMaintainCardDO> collect = carMaintainCardService.queryVehicleTypeByItemType5(itemType5);
        List<LmSaleLinkDTO> list = collect.stream().map(item ->{
            LmSaleLinkDTO lmSaleLinkDTO = new LmSaleLinkDTO();
            lmSaleLinkDTO.setVehicleNo(item.getVehicleNo());
            lmSaleLinkDTO.setVehicleType(item.getVehicleType());
            return lmSaleLinkDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(list);
    }
}
