package com.elitesland.yst.production.aftersale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.param.*;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;

import java.util.List;

public interface MaintainCardService {

    /**
     * 三包激活
     * @param vehicleThreePackageVO
     * @return
     */
    ApiResult<Object> activate(CarMaintainCardParam vehicleThreePackageVO);

    /**
     * 根据车主id查询三包车辆信息
     * @param carOwnerId
     * @return
     */
    ApiResult<Object> query(Long carOwnerId, int page, int pageSize);


    /**
     * 根据车架号查询三包信息
     * @param vehicleNo
     * @return
     */
    ApiResult<CarMaintainCardVO> queryById(String vehicleNo);
    
    
    ApiResult delByVehicleNo(CarMaintainCardDO cardDO);


    /**
     * 解绑三包激活并删除三包内容
     * @param vehicleNo 车架号
     * @return
     */
    Boolean delMaintainCard(String vehicleNo);

    /**
     * 激活三包信息 + 绑定车辆信息
     * @param carOwnerVehicleParam
     * @return
     */
    Boolean activateThreePackage2(CarOwnerVehicleParam carOwnerVehicleParam,String sourcePlatform);

    /**
     *
     * @param carOwnerVehicleParam
     * @return
     */
    Boolean activateThreePackage2Mn(CarOwnerVehicleParam carOwnerVehicleParam,String sourcePlatform);

    void sendActiveMsg(CarOwnerVehicleParam carOwnerVehicleParam);

    /**
     *
     * @param car
     */
    PagingVO<CarMaintainCardVO> page(CarOwnerMaintainCardPageParam car);


    /**
     * 获取详情
     * @param id
     * @return
     */
    CarMaintainCardVO get(Long id);

    /**
     * 撤销后该车辆所有绑定关系及三包信息将被完全移除，若需再次绑定请重新进行三包激活操作！
     * @param vehicleNos
     * @return
     */
    Boolean delAllByVehicleNo(List<String> vehicleNos);


    Boolean delAllByVehicleNoApp(List<String> vehicleNos, List<Long> collect);


    PagingVO<CarMaintainCardVO> pageApp(CarOwnerMaintainCardPageParam car, List<Long> collect);

    PagingVO<CarMaintainCardVO> pageSaleMan(CarOwnerMaintainCardPageParam car);


    void updIdCard(CarOwnverCardUpdParam updParam);
}
