package com.elitesland.yst.production.aftersale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.entity.OrderEvaluationDO;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;

import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
public interface OrderEvaluationService {
    /**
     * 工单评价保存
     * @param saveVO
     * @return id
     */
    Long save(com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam saveVO);

    /**
     * 工单评价查询
     * @param param
     * @return
     */
    OrderEvaluationVO query(OrderEvaluationParam param);

    /**
     * 工单评价分页查询
     * @param param
     * @return
     */
    PagingVO<OrderEvaluationVO> pageQuery(OrderEvaluationPageParam param);

    /**
     * 工单评价删除
     * @param ids
     */
    void orderEvaluationDelete(List<Long> ids);

    /**
     * 工单评论回访
     * @param saveVO
     */
    void orderEvaluationSolve(OrderEvaluationParam saveVO);

    /**
     * 工单评论列表
     * @param orderEvaluationParam
     */
    List<OrderEvaluationVO> queryList(OrderEvaluationParam orderEvaluationParam);

    /**
     * 工单评论批量保存
     * @param orderEvaluationDOS
     */
    void batchSave(List<OrderEvaluationDO> orderEvaluationDOS);
}
