package com.elitesland.yst.production.aftersale.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecordDO;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordPageParam;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordParam;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecordVO;

import javax.servlet.http.HttpServletResponse;

 /**
 * @author : http://www.chiner.pre
 * @date : 2023-5-10
 * @desc : 电话记录Service
 */
public interface PhoneRecordService {
    
    /**
     * 新增电话记录数据
     * @param phoneRecordParam
     * @return
     */
    PhoneRecordDO save(PhoneRecordParam phoneRecordParam);
    
     /**
     * 根据主键更新
     * @param phoneRecordParam
     * @return
     */
    PhoneRecordDO update(PhoneRecordParam phoneRecordParam);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PhoneRecordVO get(Long id);
    
     /**
     * 分页查询列表
     * @param phoneRecordPageParam
     * @return
     */
    PagingVO<PhoneRecordVO> page(PhoneRecordPageParam phoneRecordPageParam);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
     * 导出exl数据
     * @param phoneRecordPageParam
     * @param response
     */
    PagingVO<PhoneRecordVO>  export(PhoneRecordPageParam phoneRecordPageParam);
 }