package com.elitesland.yst.production.aftersale.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author RYH
 * @date 2023/8/18
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class CarOwnerInfoMngExportServiceImpl implements DataExport<CarOwnerInfoMngRespVO, CarOwnerInfoMngParam> {
    private final CarOwnerInfoService carOwnerInfoService;

    @Override
    public String getTmplCode() {
        return "car_owner_info_export";
    }

    @Override
    public PagingVO<CarOwnerInfoMngRespVO> execute(CarOwnerInfoMngParam param, int page, int pageSize) {
        param.setSize(800);
        return carOwnerInfoService.ownerInfoMngQuery(param);
    }

    @Override
    public String exportFileName() {
        return "车主信息管理导出数据";
    }
}
