package com.elitesland.yst.production.aftersale.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordPageParam;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecordVO;
import com.elitesland.yst.production.aftersale.service.PhoneRecordService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author RYH
 * @date 2023/8/19
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class PhoneRecordExportServiceImpl implements DataExport<PhoneRecordVO, PhoneRecordPageParam> {
    private final PhoneRecordService phoneRecordService;

    @Override
    public String getTmplCode() {
        return "phone_record_export";
    }

    @Override
    public PagingVO<PhoneRecordVO> execute(PhoneRecordPageParam param, int page, int pageSize) {
        param.setSize(800);
        return phoneRecordService.export(param);
    }

    @Override
    public String exportFileName() {
        return "400电话记录导出";
    }
}
