package com.elitesland.yst.production.aftersale.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author RYH
 * @date 2023/8/19
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class RepairOrderExportServiceImpl implements DataExport<RepairOrderVO, RepairOrderExlParam> {
    private final RepairOrderService repairOrderService;

    @Override
    public String getTmplCode() {
        return "repair_order_export";
    }

    @Override
    public PagingVO<RepairOrderVO> execute(RepairOrderExlParam param, int page, int pageSize) {
        param.setSize(800);
        return repairOrderService.export(param);
    }

    @Override
    public String exportFileName() {
        return "维修工单导出";
    }
}
