package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.dto.ActivateInfoDTO;
import com.elitesland.yst.production.aftersale.dto.ActivateInfoVO;
import com.elitesland.yst.production.aftersale.service.CarActivateRpcService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: lr
 * @CreateTime: 2023-09-12  11:46
 * @Description:
 * @Version: 1.0
 */
@RestController
@Service
@RequiredArgsConstructor
@RequestMapping(CarActivateRpcService.URI)
public class CarActivateRpcServiceImpl implements CarActivateRpcService {
    private final CarMaintainCardRepoProc repoProc;
    @Override
    public ApiResult<List<ActivateInfoVO>> getActivateNum(ActivateInfoDTO dto) {
        List<ActivateInfoVO> list = new ArrayList<>();
        if (null != dto) {
            list = repoProc.getActivateNum(dto);
        }
        return ApiResult.ok(list);
    }
}
