package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.aliyun.ocr_api20210707.Client;
import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponse;
import com.aliyun.tea.TeaException;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.aftersale.constant.Constant;
import com.elitesland.yst.production.aftersale.convert.CarOwnerVehicleInfoConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleRelateDO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehiclePhonePageParam;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.vo.AddressInfoVo;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.out.support.OrgStoreService;
import com.elitesland.yst.production.aftersale.provider.sale.SalesmanRpcProvider;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysAreaRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRelateRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRelateRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleServiceImpl
 * @Date2023/2/8 15:21
 */
@Service
@Log4j2
public class CarOwnerVehicleServiceImpl implements CarOwnerVehicleService {

    @Autowired
    private Constant constant;
    @Autowired
    private CarService carService;
    @Autowired
    private MaintainCardService maintainCardService;
    @Autowired
    @Lazy
    private RepairOrderService repairOrderService;
    @Autowired
    private CarOwnerVehicleRelateRepo carOwnerVehicleRelateRepo;
    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;
    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    @Autowired
    private CarOwnerVehicleRelateRepoProc carOwnerVehicleRelateRepoProc;
    @Autowired
    private CarOwnerInfoRepo carOwnerInfoRepo;
    @Autowired
    private UserService userService;
    @Autowired
    private PictureOrderRepo pictureOrderRepo;

    @Autowired
    private SalesmanRpcProvider salesmanRpcProvider;

    @Autowired
    private VinOrderRpcProvider vinOrderRpcProvider;


    @Autowired
    private SysAreaRpcProvider sysAreaRpcProvider;

    @Autowired
    private Client ocrClient;

    @Autowired
    private OrgStoreService orgStoreService;

    @Autowired
    private CrmSaleService crmSaleService;

    @Autowired
    private EmployeeRpcService employeeRpcService;

    @Autowired
    private CarMaintainCardRepoProc carMaintainCardRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> bindVehicleSave(CarOwnerVehicleParam carOwnerVehicleParam) {

        Long userId = userService.getUserId();
        carOwnerVehicleParam.setCarOwnerId(userId);
        CarOwnerVehicleInfoDO carOwnerVehicleSaveDO = CarOwnerVehicleInfoConvert.INSTANCE.carOwnerVehicleVOToDO(carOwnerVehicleParam);

        //立马车辆参数判断和赋值
        if (carOwnerVehicleParam.getVehicleSource().equals(1)) {
            Assert.notBlank(carOwnerVehicleParam.getVehicleNo(), "车架号不能为空！");

            // 0707新增校验： 一台车可以被多个用户绑定
//            CarOwnerVehicleInfoDO carOwnerVehicleInfoDO = carOwnerVehicleRepo.findByVehicleNo(carOwnerVehicleParam.getVehicleNo());
//            if (Optional.ofNullable(carOwnerVehicleInfoDO).isPresent()) {
//                throw new BusinessException("该车辆已被绑定");
//            }
            // 根据用户+车辆进行校验，该车是否已经被绑定
            Boolean isExist = this.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
            if (isExist) {
                throw new BusinessException("该用户已经绑定过此车,请勿重复绑定");
            }

            //查询该用户的手机号或身份证是否绑定一辆车
            if(carOwnerVehicleParam.getUserPhone() != null){
                int countByUserPhone = carOwnerVehicleRepo.findCountByUserPhone(carOwnerVehicleParam.getUserPhone());
                if(countByUserPhone == 1){
                    throw new BusinessException("此用户手机号已绑定一辆车，请先解绑再绑定");
                }
            }

            if(carOwnerVehicleParam.getUserIdCard() != null){
                int countByUserIdCard = carOwnerVehicleRepo.findCountByUserIdCard(carOwnerVehicleParam.getUserIdCard());
                if(countByUserIdCard == 1){
                    throw new BusinessException("此用户身份证号已绑定一辆车，请先解绑再绑定");
                }
            }
            Assert.notNull(carOwnerVehicleParam.getSalesOutletsId(), "购买门店id不能为空!");
            Assert.notBlank(carOwnerVehicleParam.getSalesOutletsName(), "购买门店name不能为空!");
            Assert.notBlank(carOwnerVehicleParam.getSalesOutletsCode(), "购买门店code不能为空!");

            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
//            carOwnerVehicleSaveDO.setPurchaseTime(constant.swapTimeMin(carOwnerVehicleParam.getPurchaseTime()));
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));
            carOwnerVehicleSaveDO.setUserBirthday(carOwnerVehicleParam.getUserBirthday());

            // 0712 新增商品编码信息
            VinOrderRpcDTO vinOrderRpcDTO = vinOrderRpcProvider.getByVinNo(carOwnerVehicleParam.getVehicleNo());
            carOwnerVehicleSaveDO.setItemId(vinOrderRpcDTO.getId());
            carOwnerVehicleSaveDO.setItemCode(vinOrderRpcDTO.getMtnrv());

            //通过销售门店ID，查询销售域接口
            //获取经销商及业务员等信息，保存至car_owner_vehicle_info（车主车辆信息表）

            log.info("销售门店ID{}", carOwnerVehicleParam.getSalesOutletsId());
            ApiResult<SalemanCustDTO> salemanCust = salesmanRpcProvider.getSalemanCust(carOwnerVehicleParam.getSalesOutletsId());
            if (salemanCust.isSuccess() && !Optional.ofNullable(salemanCust.getData()).isEmpty()) {
                SalemanCustDTO salemanCustDTO = salemanCust.getData();
                BeanUtils.copyProperties(salemanCustDTO, carOwnerVehicleSaveDO);
                carOwnerVehicleSaveDO.setSalesOutletsRegion(salemanCustDTO.getRegion());
                carOwnerVehicleSaveDO.setRegionalManager(salemanCustDTO.getRemanagerName());
                carOwnerVehicleSaveDO.setProvincialManager(salemanCustDTO.getPrmanagerName());
                carOwnerVehicleSaveDO.setSalesDirector(salemanCustDTO.getChiefName());
                //此处【REGION（区域）】是 基础域UDC
                Map<String, String> custRegionUdc = userService.sysUdcGetCodeMap("yst-supp", "REGION");
                carOwnerVehicleSaveDO.setSalesOutletsRegionName(custRegionUdc.get(salemanCustDTO.getRegion()));
                //业务员路径
                carOwnerVehicleSaveDO.setSalesmanName(salemanCustDTO.getPath() == null ? null : JSON.toJSONString(salemanCustDTO.getPath()));
            }
        }
        //非立马车辆参数判断和赋值
        if (carOwnerVehicleParam.getVehicleSource().equals(0)) {
            Assert.notBlank(carOwnerVehicleParam.getBrandName(), "品牌名称不能为空！");
            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
//            carOwnerVehicleSaveDO.setPurchaseTime(constant.swapTimeMin(carOwnerVehicleParam.getPurchaseTime()));
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));
            carOwnerVehicleSaveDO.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
        }


        CarOwnerVehicleInfoDO save = carOwnerVehicleRepo.save(carOwnerVehicleSaveDO);
        log.info("绑定车辆信息保存成功");
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = new CarOwnerVehicleRelateDO();
        carOwnerVehicleRelateDO.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carOwnerVehicleRelateDO.setVehicleType(carOwnerVehicleRelateDO.getVehicleType());
        carOwnerVehicleRelateDO.setVehicleInfoId(save.getId());
        carOwnerVehicleRelateRepo.save(carOwnerVehicleRelateDO);
        log.info("车主绑定车辆关系信息保存成功");

        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> deleteBindVehicle(Long id) {
        log.info("车辆解除绑定入参 {}", id);
        Long userId = userService.getUserId();
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = carOwnerVehicleRelateRepo.findByCarOwnerIdAndVehicleInfoId(userId, id);
        if (Optional.ofNullable(carOwnerVehicleRelateDO).isEmpty()) {
            throw new BusinessException("当前用户下，未查询到要解绑的车辆，前刷新后重试");
        }
        Optional<CarOwnerVehicleInfoDO> optional = carOwnerVehicleRepo.findById(id);
        carOwnerVehicleRepoProc.deletearOwnerVehicleInfoDO(id);
        log.info("车辆解除绑定成功 {}", id);
        carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateDO(id);
        log.info("车主与车辆关系表删除成功 {}", id);
       /* if (!optional.isEmpty() && optional.get().getVehicleSource().equals(1)) {
            CarMaintainCardDO cardDO = new CarMaintainCardDO();
            cardDO.setVehicleNo(optional.get().getVehicleNo());
            maintainCardService.delByVehicleNo(cardDO);
            log.info("车辆三包激活信息删除成功 {}", optional.get().getVehicleNo());
        }*/
        return ApiResult.ok();
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> deleteBindVehicleAndThreePack(Long id) {
        log.info("车辆解除绑定入参 {}", id);
        Long userId = userService.getUserId();
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = carOwnerVehicleRelateRepo.findByCarOwnerIdAndVehicleInfoId(userId, id);
        if (Optional.ofNullable(carOwnerVehicleRelateDO).isEmpty()) {
            throw new BusinessException("当前用户下，未查询到要解绑的车辆，前刷新后重试");
        }
        Optional<CarOwnerVehicleInfoDO> optional = carOwnerVehicleRepo.findById(id);
        carOwnerVehicleRepoProc.deletearOwnerVehicleInfoDO(id);
        log.info("车辆解除绑定成功 {}", id);
        carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateDO(id);
        log.info("车主与车辆关系表删除成功 {}", id);
        if (!optional.isEmpty() && optional.get().getVehicleSource().equals(1)) {
            String vehicleNo = optional.get().getVehicleNo();
            CarMaintainCardDO cardDO = new CarMaintainCardDO();
            cardDO.setVehicleNo(vehicleNo);
//            maintainCardService.delByVehicleNo(cardDO);
            maintainCardService.delMaintainCard(vehicleNo);
            log.info("车辆三包激活信息删除成功 ,车架号为：{}", vehicleNo);
        }
        return ApiResult.ok();
    }

    @Override
    @SysCodeProc
    public ApiResult<Object> bindVehicleQuery() {

        Long userId = userService.getUserId();
        List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = carOwnerVehicleRelateRepo.findByCarOwnerId(userId);
        if (CollUtil.isEmpty(carOwnerVehicleRelateDOList)) {
            return ApiResult.ok();
        }
        List<Long> vehicleInfoIds = carOwnerVehicleRelateDOList.stream()
                .map(CarOwnerVehicleRelateDO::getVehicleInfoId)
                .collect(Collectors.toList());
        log.info("车主绑定的车辆 {}", vehicleInfoIds.toString());
        List<CarOwnerVehicleInfoDO> ownerVehicleInfoDOS = carOwnerVehicleRepo.findAllById(vehicleInfoIds);
        List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOS = CarOwnerVehicleInfoConvert.INSTANCE.CarOwnerVehicleInfoDOToVO(ownerVehicleInfoDOS);
        int current = 1;
        for (CarOwnerVehicleInfoVO carOwnerVehicleInfoVO : carOwnerVehicleInfoVOS) {
            carOwnerVehicleInfoVO.setVehicleName("我的电动车" + current);
            current++;
        }
//        //根据车架号查询车辆/三包信息
//        this.vehicleQuery(carOwnerVehicleInfoVOS);
        log.info("车辆信息 {}", JSON.toJSONString(carOwnerVehicleInfoVOS));
        return ApiResult.ok(carOwnerVehicleInfoVOS);
    }

    @Override
    @SysCodeProc
    public List<CarOwnerVehicleInfoVO> bindVehicleMngQuery(Long carOwnerId) {
        List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = carOwnerVehicleRelateRepo.findByCarOwnerId(carOwnerId);
        if (CollUtil.isEmpty(carOwnerVehicleRelateDOList)) {
            return null;
        }
        List<Long> vehicleInfoIds = carOwnerVehicleRelateDOList.stream()
                .map(CarOwnerVehicleRelateDO::getVehicleInfoId)
                .collect(Collectors.toList());
        log.info("车主绑定的车辆 {}", vehicleInfoIds.toString());
        List<CarOwnerVehicleInfoDO> ownerVehicleInfoDOS = carOwnerVehicleRepo.findAllById(vehicleInfoIds);
        List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOS = CarOwnerVehicleInfoConvert.INSTANCE.CarOwnerVehicleInfoDOToVO(ownerVehicleInfoDOS);
        int current = 1;
        for (CarOwnerVehicleInfoVO carOwnerVehicleInfoVO : carOwnerVehicleInfoVOS) {
            carOwnerVehicleInfoVO.setVehicleName("我的电动车" + current);
            current++;
        }
//        //根据车架号查询车辆/三包信息
//        this.vehicleQuery(carOwnerVehicleInfoVOS);
        log.info("车辆信息 {}", JSON.toJSONString(carOwnerVehicleInfoVOS));
        return carOwnerVehicleInfoVOS;
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery(BindSoldVehicleParam param) {
        //1.查询当前登录人所属门店，入参门店集合与所属门店集合去重，集合空直接返回，集合不为空查询数据
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = repairOrderService.repairStoreQuery();
        List<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        param.setSalesOutletsIdS(collect);
        if (CollectionUtils.isEmpty(param.getSalesOutletsIdS())) {
            return PagingVO.<BindSoldVehicleVO>builder()
                    .total(0)
                    .records(new ArrayList<>())
                    .build();
        }

        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> bcBindSoldVehicleQuery(BindSoldVehicleParam param) {
        //1.查询当前登录人所属门店，入参门店集合与所属门店集合去重，集合空直接返回，集合不为空查询数据
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = repairOrderService.bcRepairStoreQuery();
        List<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        param.setSalesOutletsIdS(collect);
        if (CollectionUtils.isEmpty(param.getSalesOutletsIdS())) {
            return PagingVO.<BindSoldVehicleVO>builder()
                    .total(0)
                    .records(new ArrayList<>())
                    .build();
        }

        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    @SysCodeProc
    public CarOwnerVehicleInfoVO bindSoldVehicleDetail(Long id) {
        //查询车辆信息
        Optional<CarOwnerVehicleInfoDO> optional = carOwnerVehicleRepo.findById(id);
        CarOwnerVehicleInfoVO carOwnerVehicleInfoVO = new CarOwnerVehicleInfoVO();
        List<CarOwnerVehicleInfoVO> carOwnerVehicleList = new ArrayList<>();
        if (!optional.isEmpty()) {
            carOwnerVehicleInfoVO = CarOwnerVehicleInfoConvert.INSTANCE.carOwnerVehicleDOToVO(optional.get());
            //车辆三包信息
            ApiResult<CarMaintainCardVO> maintainCard = maintainCardService.queryById(carOwnerVehicleInfoVO.getVehicleNo());
            if (maintainCard.getData() != null) {
                CarMaintainCardVO carMaintainCardVO = (CarMaintainCardVO) maintainCard.getData();
                carOwnerVehicleInfoVO.setCarMaintainCardVO(carMaintainCardVO);
            } else {
                carOwnerVehicleInfoVO.setCarMaintainCardVO(null);
            }
        }
        carOwnerVehicleList.add(carOwnerVehicleInfoVO);
        //根据车架号查询车辆详情
        //this.vehicleQuery(carOwnerVehicleList);
        return carOwnerVehicleList.get(0);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> bindSoldVehicleSave(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform) {
        carOwnerVehicleParam.setSourcePlatform(sourcePlatform);
        CarOwnerInfoDO carOwnerInfoDO = carOwnerInfoRepo.findByUserPhone(carOwnerVehicleParam.getUserPhone());
        if (Optional.ofNullable(carOwnerInfoDO).isEmpty()) {
            throw new BusinessException("未查询到相关客户信息");
        }
        if (carOwnerInfoDO.getEnabledFlag().equals(0)) {
            throw new BusinessException("该手机号已被禁用");
        }
        if (null == carOwnerVehicleParam.getVehicleSource()) {
            throw new BusinessException("车辆来源 vehicleSource 不能为空");
        }
        carOwnerVehicleParam.setCarOwnerId(carOwnerInfoDO.getCarOwnerId());
        CarOwnerVehicleInfoDO carOwnerVehicleSaveDO = CarOwnerVehicleInfoConvert.INSTANCE.carOwnerVehicleVOToDO(carOwnerVehicleParam);

        //立马车辆参数判断和赋值
        if (carOwnerVehicleParam.getVehicleSource().equals(1)) {
            Assert.notBlank(carOwnerVehicleParam.getVehicleNo(), "车架号不能为空！");

            // 0707新增校验： 一台车可以被多个用户绑定
//            CarOwnerVehicleInfoDO carOwnerVehicleInfoDO = carOwnerVehicleRepo.findByVehicleNo(carOwnerVehicleParam.getVehicleNo());
//            if (Optional.ofNullable(carOwnerVehicleInfoDO).isPresent()) {
//                throw new BusinessException("该车辆已被绑定");
//            }
            Assert.notNull(carOwnerVehicleParam.getSalesOutletsId(), "购买门店id不能为空!");
            Assert.notBlank(carOwnerVehicleParam.getSalesOutletsName(), "购买门店name不能为空!");
            Assert.notBlank(carOwnerVehicleParam.getSalesOutletsCode(), "购买门店code不能为空!");

            // 根据用户+车辆进行校验，该车是否已经被绑定
            Boolean isExist = this.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
            if (isExist) {
                throw new BusinessException("该用户已经绑定过此车,请勿重复绑定");
            }

            //查询该用户的手机号或身份证是否绑定三辆车
            if(carOwnerVehicleParam.getUserPhone() != null){
                int countByUserPhone = carOwnerVehicleRepo.findCountByUserPhone(carOwnerVehicleParam.getUserPhone());
                if(countByUserPhone == 3){
                    throw new BusinessException("此用户手机号已绑定三辆车，请先解绑再绑定");
                }
            }

            if(carOwnerVehicleParam.getUserIdCard() != null){
                int countByUserIdCard = carOwnerVehicleRepo.findCountByUserIdCard(carOwnerVehicleParam.getUserIdCard());
                if(countByUserIdCard == 3){
                    throw new BusinessException("此用户身份证号已绑定三辆车，请先解绑再绑定");
                }
            }

            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
//            carOwnerVehicleSaveDO.setPurchaseTime(constant.swapTimeMin(carOwnerVehicleParam.getPurchaseTime()));
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));

            // 0712 新增商品编码信息
            VinOrderRpcDTO vinOrderRpcDTO = vinOrderRpcProvider.getByVinNo(carOwnerVehicleParam.getVehicleNo());
            carOwnerVehicleSaveDO.setItemId(vinOrderRpcDTO.getId());
            carOwnerVehicleSaveDO.setItemCode(vinOrderRpcDTO.getMtnrv());

            //通过销售门店ID，查询销售域接口
            //获取经销商及业务员等信息，保存至car_owner_vehicle_info（车主车辆信息表）

            log.info("销售门店ID{}", carOwnerVehicleParam.getSalesOutletsId());
            ApiResult<SalemanCustDTO> salemanCust = salesmanRpcProvider.getSalemanCust(carOwnerVehicleParam.getSalesOutletsId());
            if (salemanCust.isSuccess() && !Optional.ofNullable(salemanCust.getData()).isEmpty()) {
                SalemanCustDTO salemanCustDTO = salemanCust.getData();
                BeanUtils.copyProperties(salemanCustDTO, carOwnerVehicleSaveDO);
                carOwnerVehicleSaveDO.setSalesOutletsRegion(salemanCustDTO.getRegion());
                carOwnerVehicleSaveDO.setRegionalManager(salemanCustDTO.getRemanagerName());
                carOwnerVehicleSaveDO.setProvincialManager(salemanCustDTO.getPrmanagerName());
                carOwnerVehicleSaveDO.setSalesDirector(salemanCustDTO.getChiefName());
                //此处【REGION（区域）】是 基础域UDC
                Map<String, String> custRegionUdc = userService.sysUdcGetCodeMap("yst-supp", "REGION");
                carOwnerVehicleSaveDO.setSalesOutletsRegionName(custRegionUdc.get(salemanCustDTO.getRegion()));

                carOwnerVehicleSaveDO.setSalesmanName(salemanCustDTO.getPath() == null ? null : JSON.toJSONString(salemanCustDTO.getPath()));
            }
        }
        //非立马车辆参数判断和赋值
        if (carOwnerVehicleParam.getVehicleSource().equals(0)) {
            Long userId = userService.getUserId();
            List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = carOwnerVehicleRelateRepo.findByCarOwnerId(userId);
            if(!CollectionUtils.isEmpty(carOwnerVehicleRelateDOList)){
                List<Long> vehicleInfoIds = carOwnerVehicleRelateDOList.stream()
                        .map(CarOwnerVehicleRelateDO::getVehicleInfoId)
                        .collect(Collectors.toList());
                List<CarOwnerVehicleInfoDO> ownerVehicleInfoDOS = carOwnerVehicleRepo.findAllById(vehicleInfoIds);
                Optional<CarOwnerVehicleInfoDO> op = ownerVehicleInfoDOS.stream().filter(x -> 0 == x.getVehicleSource()).findFirst();
                if(op.isPresent()){
                    throw new BusinessException("非立马车辆只允许绑定一辆");
                }
            }
            //Assert.notBlank(carOwnerVehicleParam.getBrandName(),"品牌名称不能为空！");
            carOwnerVehicleSaveDO.setBindingTime(LocalDateTime.now());
//            carOwnerVehicleSaveDO.setPurchaseTime(constant.swapTimeMin(carOwnerVehicleParam.getPurchaseTime()));
            carOwnerVehicleSaveDO.setPurchaseTime(LocalDateTime.of(carOwnerVehicleParam.getPurchaseTime(), LocalTime.MIN));

        }
        CarOwnerVehicleInfoDO save = carOwnerVehicleRepo.save(carOwnerVehicleSaveDO);
        log.info("绑定车辆信息保存成功");
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = new CarOwnerVehicleRelateDO();
        carOwnerVehicleRelateDO.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carOwnerVehicleRelateDO.setVehicleType(carOwnerVehicleRelateDO.getVehicleType());
        carOwnerVehicleRelateDO.setVehicleInfoId(save.getId());
        carOwnerVehicleRelateRepo.save(carOwnerVehicleRelateDO);
        log.info("车主绑定车辆关系信息保存成功");
        return ApiResult.ok(save.getId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> deleteBindVehicleToFront(String userPhone, String userName, Long vehicleInfoId) {
        log.info("车辆解除绑定入参【{}, {}, {}】", userPhone, userName, vehicleInfoId);
        CarOwnerInfoDO carOwnerInfoDO = carOwnerInfoRepo.findByUserPhone(userPhone);
        if (Optional.ofNullable(carOwnerInfoDO).isEmpty()) {
            throw new BusinessException("未查询到相关客户信息");
        }
        Long carOwnerId = carOwnerInfoDO.getCarOwnerId();
        CarOwnerVehicleRelateDO carOwnerVehicleRelateDO = carOwnerVehicleRelateRepo.findByCarOwnerIdAndVehicleInfoId(carOwnerId, vehicleInfoId);
        if (Optional.ofNullable(carOwnerVehicleRelateDO).isEmpty()) {
            throw new BusinessException("当前用户下，未查询到要解绑的车辆，前刷新后重试");
        }
        Optional<CarOwnerVehicleInfoDO> optional = carOwnerVehicleRepo.findById(vehicleInfoId);
        carOwnerVehicleRepoProc.deletearOwnerVehicleInfoDO(vehicleInfoId);
        log.info("车辆解除绑定成功 {}", vehicleInfoId);
        carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateDO(vehicleInfoId);
        log.info("车主与车辆关系表删除成功 {}", vehicleInfoId);
        if (!optional.isEmpty() && optional.get().getVehicleSource().equals(1)) {
            CarMaintainCardDO cardDO = new CarMaintainCardDO();
            cardDO.setVehicleNo(optional.get().getVehicleNo());
            maintainCardService.delByVehicleNo(cardDO);
            log.info("车辆三包信息删除成功 {}", optional.get().getVehicleNo());
        }
        return ApiResult.ok();
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> vehicleBindInfoQuery(BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @Override
    public AddressInfoVo queryByUserCardId(String userCardId) {
        // 根据身份证前2位获取省份信息
        String address = userCardId.substring(0, 2);
        address = address + "0000";
        Set<String> set = new HashSet<>();
        set.add(address);
        AddressInfoVo addressInfoVo = new AddressInfoVo();
        addressInfoVo.setProvinceCode(address);

        List<SysAreaRespDTO> data = sysAreaRpcProvider.listByAreaCodes(set);
        if (data != null && data.size() != 0) {
            addressInfoVo.setProvince(data.get(0).getAreaName());
        }

        // 根据身份证号前4位获取省市信息
        address = userCardId.substring(0, 4);
        address = address + "00";
        set.clear();
        set.add(address);
        addressInfoVo.setCityCode(address);
        List<SysAreaRespDTO> data1 = sysAreaRpcProvider.listByAreaCodes(set);
        if (data1 != null && data1.size() != 0) {
            addressInfoVo.setCity(data1.get(0).getAreaName());
        }

        // 根据身份证号获取出生年月
        address = userCardId.substring(6, 14);
        addressInfoVo.setUserBirthday(LocalDate.of(Integer.parseInt(address.substring(0, 4)), Integer.parseInt(address.substring(4, 6)), Integer.parseInt(address.substring(6, 8))));

        // 根据身份证号获取性别
        address = userCardId.substring(16, 17);
        if (Integer.parseInt(address) % 2 > 0) {
            addressInfoVo.setUserSex("1");
        } else {
            addressInfoVo.setUserSex("0");
        }
        return addressInfoVo;
    }

    @Override
    public RecognizeIdcardResponse ocrScan(MultipartFile file) {
        try {
            // 需要安装额外的依赖库，直接点击下载完整工程即可看到所有依赖。
            java.io.InputStream bodyStream = file.getInputStream();
            com.aliyun.ocr_api20210707.models.RecognizeIdcardRequest recognizeIdcardRequest = new com.aliyun.ocr_api20210707.models.RecognizeIdcardRequest()
                    .setBody(bodyStream);
            com.aliyun.teautil.models.RuntimeOptions runtime = new com.aliyun.teautil.models.RuntimeOptions();
            // 复制代码运行请自行打印 API 的返回值
            return ocrClient.recognizeIdcardWithOptions(recognizeIdcardRequest, runtime);
        } catch (TeaException error) {
            // 如有需要，请打印 error
            throw new BusinessException(com.aliyun.teautil.Common.assertAsString(error.message));
        } catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), _error);
            // 如有需要，请打印 error
            throw new BusinessException(com.aliyun.teautil.Common.assertAsString(error.message));
        }
    }

    /**
     * 客户历史信息修复接口
     *
     * @param param
     * @return
     */
    @Override
    public ApiResult<Object> custDateRepair(BindSoldVehicleParam param) {
        Map<Long, String> storeIdAndCustCodeMap = new HashMap<>();
        List<SalesmanLevelInfoDTO> listApiResult = new ArrayList<>();
        if (param.getStartTime() == null || param.getEndTime() == null) {
            throw new BusinessException("开始时间和结束时间不能为空");
        }
        List<CarOwnerVehicleInfoDO> bindSoldVehicleVOS = carOwnerVehicleRepo.findByBindingTimeOrVehicleNo(param.getStartTime(), param.getEndTime(), 1, param.getActivatFlag(), param.getVehicleNo());
//        List<CarOwnerVehicleInfoDO> bindSoldVehicleVOS = carOwnerVehicleRepoProc.bindVehicleQuery2(param);
        log.info("车主信息表返回信息:【" + bindSoldVehicleVOS + "】");
        if (CollectionUtils.isEmpty(bindSoldVehicleVOS)) {
            throw new BusinessException("未查询到相关信息");
        }
        List<Long> collect = bindSoldVehicleVOS.stream().map(CarOwnerVehicleInfoDO::getSalesOutletsId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw new BusinessException("车主信息表中门店id为空");
        }
        log.info("门店入参信息:【" + collect + "】");
        List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = orgStoreService.queryByIds(collect);
        if (CollectionUtils.isEmpty(orgStoreDetailRpcDTOS)) {
            throw new BusinessException("门店信息查询为空");
        }

        log.info("门店出参信息:【" + orgStoreDetailRpcDTOS + "】");
        List<String> codeList = orgStoreDetailRpcDTOS.stream().filter(t -> t.getPcode() != null).map(OrgStoreDetailRpcDTO::getPcode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codeList)) {
            throw new BusinessException("门店pcode为空");
        }
        orgStoreDetailRpcDTOS.stream().forEach(t -> {
            storeIdAndCustCodeMap.put(t.getId(), t.getPcode());
        });

        CrmCustRpcDtoParam crmCustRpcDtoParam = new CrmCustRpcDtoParam();
        crmCustRpcDtoParam.setCustCodes(codeList);
        List<CrmCustRespDTO> custByParam = crmSaleService.getCustByParam(crmCustRpcDtoParam);
        if (CollectionUtils.isEmpty(custByParam)) {
            throw new BusinessException("客户信息为空");
        }
        log.info("客户出参信息:【" + custByParam + "】");
        List<Long> empIds = bindSoldVehicleVOS.stream().filter(t -> t.getRemark() != null && t.getRemark() != "").map(CarOwnerVehicleInfoDO::getRemark).mapToLong(t -> Long.parseLong(t.trim())).boxed().distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(empIds)) {
            listApiResult = crmSaleService.queryLevelInfos(empIds).getData();
        }


        //开始填充数据
        List<SalesmanLevelInfoDTO> finalListApiResult = listApiResult;
        bindSoldVehicleVOS.stream().forEach(t -> {
            String custCode = storeIdAndCustCodeMap.get(t.getSalesOutletsId());
            Optional<CrmCustRespDTO> first = custByParam.stream().filter(cust -> custCode.equals(cust.getCustCode())).findFirst();
            if (first.isPresent() && Objects.nonNull(first.get())) {
                t.setCustCode(first.get().getCustCode());
                t.setCustName(first.get().getCustName());
                t.setCustAbbr(first.get().getCustAbbr());
                t.setCustCode2(first.get().getCustCode2());
            }
            if (t.getRemark() != null && t.getRemark() != "" && !CollectionUtils.isEmpty(finalListApiResult)) {
                List<SalesmanLevelInfoDTO> collect1 = finalListApiResult.stream().filter(sale -> sale.getId().toString().equals(t.getRemark())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect1)) {
                    if (!Optional.ofNullable(collect1.stream().findFirst().get()).isEmpty()) {
                        SalesmanLevelInfoDTO salesmanLevelInfoDTO = collect1.stream().findFirst().get();
                        t.setSalesmanName(salesmanLevelInfoDTO.getSalesman_path() == null ? null : JSON.toJSONString(salesmanLevelInfoDTO.getSalesman_path()));
                    }
                }
            }
        });

        log.info("车主信息保存信息:【" + bindSoldVehicleVOS + "】");

        bindSoldVehicleVOS.stream().forEach(t -> {
            carOwnerVehicleRepo.updateCustAndSalesManName(t.getCustCode(), t.getCustName(), t.getCustAbbr(), t.getCustCode2(), t.getSalesmanName(), t.getId());
        });

        return ApiResult.ok();

    }

    public void vehicleQuery(List<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVO) {
        List<String> collect = carOwnerVehicleInfoVO.stream().filter(t -> t.getVehicleNo() != null).map(CarOwnerVehicleInfoVO::getVehicleNo).collect(Collectors.toList());
        CarParam carParam = new CarParam();
        carParam.setVehicleNoList(collect);
        List<CarVO> data = carService.queryList(carParam).getData();
        //对应车辆信息赋值
        carOwnerVehicleInfoVO.stream().forEach(t -> {
            Optional<CarVO> first = data.stream().filter(car -> car.getVehicleNo().equals(t.getVehicleNo())).findFirst();
            if (first.isPresent()) {
                t.setVehicleName(first.get().getVehicleName());
                t.setVehicleNo(first.get().getVehicleNo());
                t.setVehicleSource(Integer.valueOf(first.get().getVehicleSource()));
                t.setVehicleSpecs(first.get().getVehicleSpecs());
                t.setBindingTime(first.get().getBindingTime());
                t.setPurchaseTime(first.get().getPurchaseTime());
                t.setMaintainCardNo(first.get().getMaintainCardNo());
            }
        });
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCarowner(CarOwnerInfoDO carOwnerInfoDO) {
        if (StringUtils.isBlank(carOwnerInfoDO.getUserPhone())) {
            return;
        }
        if (StringUtils.isBlank(carOwnerInfoDO.getUserName())) {
            return;
        }
        carOwnerVehicleRepoProc.updateCarowner(carOwnerInfoDO);


    }

    @Override
    public List<CarOwnerVehicleInfoVO> findCarByUserPhone(String phone) {

        if (StringUtils.isBlank(phone)) {
            return new ArrayList<>();
        }
        List<CarOwnerVehicleInfoVO> res = carOwnerVehicleRepoProc.findCarByUserPhone(phone);

        return res;
    }

    @Override
    public List<BindSoldVehicleVO> findCustByVehicleNo(List<String> vehicleNoList) {

        if(org.springframework.util.CollectionUtils.isEmpty(vehicleNoList)){
            return new ArrayList<>();
        }

        List<BindSoldVehicleVO> res = carOwnerVehicleRepoProc.findCustByVehicleNo(vehicleNoList);
        return res;
    }

    @Override
    public Boolean existBy(String userPhone, String vehicleNo) {
        if (StringUtils.isBlank(userPhone)) {
            throw new BusinessException("userPhone 不能为空");
        }
        if (StringUtils.isBlank(vehicleNo)) {
            throw new BusinessException("vehicleNo 不能为空");
        }

        int a = carOwnerVehicleRepoProc.existBy(userPhone, vehicleNo);
        return a > 0;
    }

    @Override
    public Boolean existByPhoneAId(String userPhone, String userIdcard) {
        if (StringUtils.isBlank(userPhone) && StringUtils.isBlank(userIdcard)) {
            throw new BusinessException("userPhone或userIdcard 不能为空");
        }
        // 车辆三包激活拦截取车辆三包信息表
//        int a = carOwnerVehicleRepoProc.existByPhoneAId(userPhone, userIdcard);
        int a = carMaintainCardRepoProc.existByPhoneAId(userPhone, userIdcard);
        return a > 0;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateActivatFlag(String userPhone, String vehicleNo, boolean b) {
        carOwnerVehicleRepoProc.updateActivatFlag(userPhone, vehicleNo, b);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CarOwnerVehicleInfoVO getByVerNo(String vehicleNo) {

        CarOwnerVehicleInfoVO res = carOwnerVehicleRepoProc.getByVerNo(vehicleNo);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<BindSoldVehicleVO> vehicleBindInfoQuerySaleMan(BindSoldVehicleParam param) {
        ApiResult<SysEmployeeBasicDTO> result = employeeRpcService.getByUserId(userService.getUserId());
        if(result.getData() == null || StringUtils.isEmpty(result.getData().getCode())){
            throw new BusinessException("当前用户获取员工code为空！！！");
        }

        if(!"SALESMAN".equals(result.getData().getType())){
            throw new BusinessException("当前登录人非业务员无法使用此页面");
        }
        String empCode = result.getData().getCode();
        List<Long> storeIdList = crmSaleService.querySaleManStoreIds(empCode);
        if(org.springframework.util.CollectionUtils.isEmpty(storeIdList)){
            return PagingVO.<BindSoldVehicleVO>builder()
                    .total(0)
                    .build();
        }
        param.setSalesOutletsIds2(storeIdList);
        PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery = carOwnerVehicleRepoProc.bindSoldVehicleQuery(param);
        return bindSoldVehicleQuery;
    }

    @SysCodeProc
    @Override
    public PagingVO<CarOwnerVehicleInfoVO> queryPageByPhone(CarOwnerVehiclePhonePageParam bindSoldVehicleParam) {
        if(StringUtils.isEmpty(bindSoldVehicleParam.getUserPhone())){
            throw new BusinessException("手机号不能为空!");
        }
        return carOwnerVehicleRepoProc.findCarByUserPhonePage(bindSoldVehicleParam);
    }

    @Override
    public Integer getUserFlmVehicleBindQty() {
        Long userId = userService.getUserId();
        List<CarOwnerVehicleRelateDO> carOwnerVehicleRelateDOList = carOwnerVehicleRelateRepo.findByCarOwnerId(userId);
        if(!CollectionUtils.isEmpty(carOwnerVehicleRelateDOList)){
            List<Long> vehicleInfoIds = carOwnerVehicleRelateDOList.stream()
                    .map(CarOwnerVehicleRelateDO::getVehicleInfoId)
                    .collect(Collectors.toList());
            List<CarOwnerVehicleInfoDO> ownerVehicleInfoDOS = carOwnerVehicleRepo.findAllById(vehicleInfoIds);
            List<CarOwnerVehicleInfoDO> ownerVehicleInfoDOS2 = ownerVehicleInfoDOS.stream().filter(x -> 0 == x.getVehicleSource()).collect(Collectors.toList());
            return ownerVehicleInfoDOS2.size();
        }
        return 0;
    }
//    public void vehicleSaleStatistics(){
//        log.info("开始统计业务员绑定车辆数据");
//        //获取当前时间，前一天的开始时间
//        LocalDateTime yesterday_start = LocalDateTime.of(LocalDate.now().minusDays(1), LocalTime.MIN);
//        //获取当前时间，前一天的结束时间
//        LocalDateTime yesterday_end = LocalDateTime.of(LocalDate.now().minusDays(1), LocalTime.MAX);
//        //统计前一天 业务员绑定车辆的数据
//        //此处暂时先以map方式返回统计数据，key为业务员编号，value为统计数量
//        Map<String, Long> vehicleSaleStatisticsMap = carOwnerVehicleRepoProc.vehicleSaleStatistics(yesterday_start,yesterday_end);
//        //根据后续业务需求，如何调用其他域接口进行传参汇总
//
//
//        log.info("结束统计业务员绑定车辆数据");
//    }


}
