package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.convert.CarConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.ItemBackupsDO;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.param.VehicleQueryParam;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryVehicleVO;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.support.LmItmItemRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.repo.BatteryVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.ItemBackupsRepoProc;
import com.elitesland.yst.production.order.rpc.LmVehicleNoRpcService;
import com.elitesland.yst.production.order.rpc.param.resp.LmVehicleNoTimeDTO;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.LmItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcParam;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Service
@Log4j2
public class CarServiceImpl implements CarService {

    @Autowired
    private LmItmItemRpcProvider lmItmItemRpcProvider;

    @Autowired
    private VinOrderRpcProvider vinOrderRpcProvider;

    @Autowired
    private ItemBackupsRepoProc itemBackupsRepoProc;

    @Autowired
    private LmVehicleNoRpcService vehicleNoRpcService;

    // 车辆三包信息
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;

    @Autowired
    private BatteryVehicleRepoProc batteryVehicleRepoProc;

    /**
     * 支撑域暂时无法支持，本接口先写死返回数据，便于联调
     *
     * @param queryDTO 查询参数
     * @return
     */
    @Override
    public ApiResult<List<CarVO>> queryList(CarParam queryDTO) {
        //暂时返回特定数据
        List<CarVO> carVOList = new ArrayList<>();
        CarVO storeRespVO = new CarVO();
        storeRespVO.setVehicleNo("【测试数据】ve110120130");
        storeRespVO.setVehicleSpecs("【测试数据】8888");
        storeRespVO.setVehicleSource("【测试数据】线上销售");
        storeRespVO.setMaintainCardNo("【测试数据】66666");
        storeRespVO.setVehicleType("【测试数据】车型");
        carVOList.add(storeRespVO);
        return ApiResult.ok(carVOList);
    }

    /**
     *
     *
     * @param queryDTO 查询参数
     * @return
     */
    @Override
    public ApiResult<CarVO> query(CarParam queryDTO) {
        //通过车架号&整车号 查询销售域
        //获取车辆生产信息
        log.info("车架号{}", queryDTO.getVehicleNo());
        VinOrderRpcDTO vinOrderRpcDTO = vinOrderRpcProvider.getByVinNo(queryDTO.getVehicleNo());
        CarVO carVO = CarConvert.INSTANCE.carRpcDTOTOVO(vinOrderRpcDTO);

        //库存物料(商品编码) 查询基础域
        //获取车辆颜色，车型信息
        log.info("库存物料(商品编码) {}", vinOrderRpcDTO.getMtnrv());
        ItmItemRpcParam param = new ItmItemRpcParam();
        List<String> itemCodes = new ArrayList<>();
        itemCodes.add(vinOrderRpcDTO.getMtnrv());
        param.setItemCodes(itemCodes);
        List<LmItmItemRpcDTO> lmItmItemList = lmItmItemRpcProvider.findSkuByParam(param);

        //临时处理
        if (CollectionUtils.isNotEmpty(lmItmItemList)) {
            String itemAttr = lmItmItemList.get(0).getItemAttr();
            String color = null;
            JSONArray jsonArray = JSONArray.parseArray(itemAttr);
            for (Object ja : jsonArray) {
                JSONObject jsonObject = (JSONObject) ja;
                String name = jsonObject.getString("name");
                String value = jsonObject.getString("value");
                if ("颜色".equals(name)) {
                    color = value;
                }
            }

            //vehicle_type(车型) = itemType5 + "/" + itemType5Name + "/" + spuName
            String vehicleType = "";
            vehicleType = concatStr(vehicleType, lmItmItemList.get(0).getItemType5());
            vehicleType = concatStr(vehicleType, lmItmItemList.get(0).getItemType5Name());
            vehicleType = concatStr(vehicleType, lmItmItemList.get(0).getSpuName());

            carVO.setVehicleType(vehicleType);
            carVO.setVehicleColor(color);
            carVO.setVehicleSpecs(lmItmItemList.get(0).getItemName());
            carVO.setItemType3(lmItmItemList.get(0).getItemType3());
            carVO.setVehicleNo(vinOrderRpcDTO.getVinNo());
            carVO.setItemGroup2(lmItmItemList.get(0).getItemGroup2());
            carVO.setSpuCode(lmItmItemList.get(0).getSpuCode());
        } else {
            List<ItemBackupsDO> itemBackupsDOS = itemBackupsRepoProc.itemQuery(vinOrderRpcDTO.getMtnrv());
            if (CollectionUtils.isEmpty(itemBackupsDOS)) {
                throw new BusinessException("未查询到车辆属性信息");
            }
            //vehicle_type(车型) = itemType5 + "/" + itemType5Name + "/" + spuName
            String vehicleType = "";
            vehicleType = concatStr(vehicleType, itemBackupsDOS.get(0).getItemType5());
            vehicleType = concatStr(vehicleType, itemBackupsDOS.get(0).getSpuName());

            carVO.setVehicleType(vehicleType);
            carVO.setVehicleColor(itemBackupsDOS.get(0).getColor());
            carVO.setVehicleSpecs(itemBackupsDOS.get(0).getItemName());
            carVO.setItemType3("230");
            carVO.setVehicleNo(vinOrderRpcDTO.getVinNo());
        }

        // 出库日期
        String veNo = carVO.getVehicleNo();
        LmVehicleNoTimeDTO vehicleNoInfo = vehicleNoRpcService.getDocTimeByVehicle(veNo);
        if(vehicleNoInfo != null) {
            carVO.setDocTime(vehicleNoInfo.getDocTime());
            carVO.setManufactureDate(vehicleNoInfo.getOfflineTime());
        }

        // 绑定激活时间
        CarMaintainCardDO carMaintainCardDO = carMaintainCardRepo.findByVehicleNoAndDeleteFlag(veNo, 0);
        if(carMaintainCardDO != null) {
            carVO.setBindActiveTime(carMaintainCardDO.getCreateTime());
        }

        // 获取整车电池数量
        VehicleQueryParam vehicleQueryParam = new VehicleQueryParam();
        vehicleQueryParam.setItemGroup2(carVO.getItemGroup2());
        vehicleQueryParam.setCode(carVO.getSpuCode());
//        vehicleQueryParam.setSpuName(carVO.getVehicleName());

        int batteryNum = 0;
        List<BatteryVehicleVO> list = batteryVehicleRepoProc.vehicleInfo(carVO.getItemGroup2(), carVO.getSpuCode());
        if(StringUtils.isBlank(carVO.getItemGroup2())){
            for(BatteryVehicleVO batteryVehicleVO:list){
                if(StringUtils.isBlank(batteryVehicleVO.getItemGroup2())){
                    batteryNum = batteryVehicleVO.getBatteryNum();
                    carVO.setSpuName(batteryVehicleVO.getSpuName());
                    carVO.setBatteryNum(batteryNum);
                    return ApiResult.ok(carVO);
                }
            }
        }else if(StringUtils.isNotBlank(carVO.getItemGroup2())&&CollectionUtils.isEmpty(list)){
            List<BatteryVehicleVO> list1=batteryVehicleRepoProc.vehicleInfo(null, carVO.getSpuCode());
            for(BatteryVehicleVO batteryVehicleVO:list1){
                if(StringUtils.isBlank(batteryVehicleVO.getItemGroup2())){
                    batteryNum = batteryVehicleVO.getBatteryNum();
                    carVO.setSpuName(batteryVehicleVO.getSpuName());
                    carVO.setBatteryNum(batteryNum);
                    return ApiResult.ok(carVO);
                }
            }
        }else{
            BatteryVehicleVO batteryVehicleVO = list.get(0);
            batteryNum = batteryVehicleVO.getBatteryNum();
            carVO.setSpuName(batteryVehicleVO.getSpuName());
        }
//        if(!list.isEmpty()){
//            BatteryVehicleVO batteryVehicleVO = list.get(0);
//            if(batteryVehicleVO != null){
//                batteryNum = batteryVehicleVO.getBatteryNum();
//                carVO.setSpuName(batteryVehicleVO.getSpuName());
//            }else{
//                List<BatteryVehicleVO> list2 = batteryVehicleRepoProc.vehicleInfo(null, carVO.getSpuCode());
//                if(!list2.isEmpty()){
//                    for (BatteryVehicleVO vehicleVO : list2) {
//                        if(vehicleVO.getItemGroup2() == null){
//                            batteryNum = vehicleVO.getBatteryNum();
//                            carVO.setSpuName(vehicleVO.getSpuName());
//                        }
//                    }
//                }
//            }
//        }
        carVO.setBatteryNum(batteryNum);
        return ApiResult.ok(carVO);
    }

    @Override
    public List<CarVO> carList() {
        //暂时返回特定数据
        List<CarVO> carVOList = new ArrayList<>();
        CarVO carVO = this.carSave();
        carVO.setVehicleNo("【测试数据】ve110120130");
        CarVO carVO1 = this.carSave();
        carVO1.setVehicleNo("【测试数据】yuanshen1234");
        CarVO carVO2 = this.carSave();
        carVO2.setVehicleNo("【测试数据】henan666");
        CarVO carVO3 = this.carSave();
        carVO3.setVehicleNo("【测试数据】8555553568");
        CarVO carVO4 = this.carSave();
        carVO4.setVehicleNo("【测试数据】8555553569");

        carVOList.add(carVO);
        carVOList.add(carVO1);
        carVOList.add(carVO2);
        carVOList.add(carVO3);
        carVOList.add(carVO4);

        return carVOList;
    }

    public CarVO carSave() {

        CarVO storeRespVO = new CarVO();
        storeRespVO.setVehicleSource("【测试数据】线上销售");
        storeRespVO.setMaintainCardNo("【测试数据】66666");
        storeRespVO.setVehicleColor("【测试数据】内贴意式-月光白+金属艳红+炫光蓝绿+闪电银");
        storeRespVO.setVehicleSpecs("【测试数据】215-23电机/30A(ECU)/- 键修复1前铁轮/3.00-10真空/φ27铝直筒1/后普通/前后碟刹/LED仪表/中轴/硬贴/内贴/特斯拉WX");
        storeRespVO.setMachineNo("【测试数据】LM36V350WBBB012301022116");
        storeRespVO.setVehicleType("【测试数据】车型");
        storeRespVO.setPurchaseTime(LocalDateTime.now());
        return storeRespVO;
    }

    public String concatStr(String name, String param) {
        if (!StringUtils.isEmpty(param)) {
            name = name.equals("") ? param : name.concat("/").concat(param);
        }
        return name;
    }


}
