package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;

import com.elitesland.yst.production.aftersale.convert.OrderLogConvert;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.elitesland.yst.production.aftersale.service.OrderLogService;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepo;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepoProc;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Log4j2
public class OrderLogServiceImpl implements OrderLogService {
    @Autowired
    private OrderLogRepoProc orderLogRepoProc;
    @Autowired
    private OrderLogRepo orderLogRepo;

    /**
     * 工单日志查询
     *
     * @param param 查询参数
     * @return
     */
    @Override
    public List<OrderLogVO> query(OrderLogPageParam param) {
        if (param.getOrderId() == null || param.getOrderId() == 0) {
            throw new BusinessException(ApiCode.FAIL, "工单id为空");
        }
        List<OrderLogVO> query = orderLogRepoProc.query(param);
        query.stream().forEach(t -> {
            if (StringUtils.isNotEmpty(t.getOrderType()) && "1".equals(t.getOrderType())) {
                t.setOrderTypeName("维修工单");
            }
            if (StringUtils.isNotEmpty(t.getOrderType()) && "2".equals(t.getOrderType())) {
                t.setOrderTypeName("客诉工单");
            }
        });
        return query;
    }


    @Override
    public Long orderLogSave(OrderLogSaveParam saveParam) {
        OrderLogDO orderLogDO = OrderLogConvert.INSTANCE.saveVoTODO(saveParam);
        return orderLogRepo.save(orderLogDO).getId();
    }

    @Override
    public void batchSave(List<OrderLogDO> orderLogDOS) {
        orderLogRepo.saveAll(orderLogDOS);
    }


}
