package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitesland.yst.production.aftersale.convert.RepairPartsServiceConvert;
import com.elitesland.yst.production.aftersale.model.entity.RepairPartsServiceDO;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairPartsServiceVO;
import com.elitesland.yst.production.aftersale.service.RepairPartsService;
import com.elitesland.yst.production.aftersale.service.repo.RepairPartsServiceRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairPartsServiceRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@Service
@Log4j2
@RequiredArgsConstructor
public class RepairPartsServiceImpl implements RepairPartsService {

    private final RepairPartsServiceRepoProc repairPartsServiceRepoProc;
    private final RepairPartsServiceRepo repairPartsServiceRepo;


    @Override
    public PagingVO<RepairPartsServiceVO> pageQuery(RepairPartsServiceExlParam queryDTO) {
        queryDTO.setServiceType("1");
        PagingVO<RepairPartsServiceVO> query = repairPartsServiceRepoProc.pageQuery(queryDTO);
        query.stream().forEach(t -> {
            if (StringUtils.isNotEmpty(t.getServiceType()) && "1".equals(t.getServiceType())) {
                t.setServiceTypeName("配件服务");
            }
            if (StringUtils.isNotEmpty(t.getServiceType()) && "2".equals(t.getServiceType())) {
                t.setServiceTypeName("增值服务");
            }
        });
        return query;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceParam saveVO) {

        RepairPartsServiceDO repairPartsServiceDO = RepairPartsServiceConvert.INSTANCE.saveVoTODO(saveVO);
        Long id = repairPartsServiceRepo.save(repairPartsServiceDO).getId();
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> saveList(List<RepairPartsServiceParam> saveVOList) {
        //校验
        if (CollectionUtils.isEmpty(saveVOList)) {
            throw new BusinessException(ApiCode.FAIL, "配件服务保存集合为空");
        }
        ;
        List<RepairPartsServiceDO> collect = saveVOList.stream().map(t -> {
            RepairPartsServiceDO repairPartsServiceDO = RepairPartsServiceConvert.INSTANCE.saveVoTODO(t);
            return repairPartsServiceDO;
        }).collect(Collectors.toList());
        List<Long> ids = repairPartsServiceRepo.saveAll(collect).stream().map(RepairPartsServiceDO::getId).collect(Collectors.toList());

        return ids;
    }
}
