package com.elitesland.yst.production.aftersale.service.impl;


import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * 用户信息相关服务
 *
 * @author Danny.Wang
 * @title UserService
 * @Date2023/2/16 14:53
 */
@Component
@Log4j2
public class UserService {

    @Autowired
    private UdcProvider udcProvider;

    //获取当前登录车主id
    public Long getUserId() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Optional.ofNullable(userDetails).isEmpty()) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "未认证或身份认证已过期，请重新登录", null);
        }
        Long userId = userDetails.getUserId();
        log.info("车主id {}", userId);
        return userId;
    }

    //获取当前登录车主id
    public SysUserDTO getUserDetail() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Optional.ofNullable(userDetails).isEmpty()) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "未认证或身份认证已过期，请重新登录", null);
        }
        return userDetails.getUser();
    }

    /**
     * udc翻译
     *
     * @param domain
     * @param udc
     * @return
     */
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map<String, String> codeMap = udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap;
        } catch (Exception e) {
            log.error("findCodeBatch error:{}", e);
        }
        return new HashMap<>();
    }

}
