package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.BatteryGuaranteesDO;
import com.elitesland.yst.production.aftersale.model.entity.QBatteryCodesDO;
import com.elitesland.yst.production.aftersale.model.entity.QBatteryGuaranteesDO;
import com.elitesland.yst.production.aftersale.model.param.BatteryGuaranteesParam;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryGuaranteesVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

@Repository
public class BatteryGuaranteesRepoProc extends BaseRepoProc<BatteryGuaranteesDO> {

    private static final QBatteryGuaranteesDO QGDO = QBatteryGuaranteesDO.batteryGuaranteesDO;
    private static final QBatteryCodesDO QDO = QBatteryCodesDO.batteryCodesDO;

    protected BatteryGuaranteesRepoProc() {
        super(QGDO);
    }

    public PagingVO<BatteryGuaranteesVO> queryBatteryGuarantees(BatteryGuaranteesParam param) {
        Predicate predicate = PredicateBuilder.builder().
        andEq(QGDO.deleteFlag,0).
        andEq(StringUtils.hasText(param.getCode()), QGDO.code, param.getCode()).
        andEq(StringUtils.hasText(param.getType()), QGDO.type, param.getType()).
        andEq(StringUtils.hasText(param.getFgCode()), QDO.fgCode, param.getFgCode()).
        andEq(StringUtils.hasText(param.getFactoryCode()), QDO.factoryCode, param.getFactoryCode()).
        andLike(StringUtils.hasText(param.getFactoryName()), QDO.factoryName, "%" + param.getFactoryName()  + "%").
        andEq(StringUtils.hasText(param.getVehicleType()), QGDO.vehicleType, param.getVehicleType()).
        andLike(StringUtils.hasText(param.getSpuName()), QGDO.spuName, "%" +param.getSpuName() + "%").
        andLike(StringUtils.hasText(param.getVehicleSpecs()), QGDO.vehicleSpecs, "%" + param.getVehicleSpecs() + "%").
        andEq(StringUtils.hasText(param.getMtnrv()), QGDO.mtnrv, param.getMtnrv()).
        andLike(StringUtils.hasText(param.getProdSpecs()), QDO.prodSpecs, "%" + param.getProdSpecs()+ "%").
        andLike(StringUtils.hasText(param.getProdCategory()), QDO.prodCategory, "%" + param.getProdCategory()+ "%").
        andLike(StringUtils.hasText(param.getVehicleNo()), QGDO.vehicleNo, "%" + param.getVehicleNo()+ "%").
        andEq(StringUtils.hasText(param.getSaleRegion()), QGDO.saleRegion, param.getSaleRegion()).
        andEq(StringUtils.hasText(param.getProvince()), QGDO.province, param.getProvince()).
        andLike(StringUtils.hasText(param.getSalesOutletsName()), QGDO.storeName, "%" +param.getSalesOutletsName() + "%").
        andEq(StringUtils.hasText(param.getProducer()), QDO.producer, param.getProducer()).
        andLike(StringUtils.hasText(param.getDealerName()), QGDO.dealerName, "%" + param.getDealerName() + "%").
        andLike(StringUtils.hasText(param.getOwnerName()), QGDO.ownerName, "%" + param.getOwnerName() + "%").
        andLike(StringUtils.hasText(param.getIdCard()), QGDO.idCard, "%" + param.getIdCard() + "%").
        andLike(StringUtils.hasText(param.getOwnerMobile()), QGDO.ownerMobile, "%" + param.getOwnerMobile() + "%").
        andBetween(
                param.getGuaranteesTimeS() != null && param.getGuaranteesTimeE() != null,
                QGDO.guaranteesTime, param.getGuaranteesTimeS(), param.getGuaranteesTimeE()
        ).
        andBetween(
                param.getFactoryOutTimeS() != null && param.getFactoryOutTimeE() != null,
                QDO.factoryOutTime, param.getFactoryOutTimeS(), param.getFactoryOutTimeE()
        ).
        andBetween(
                param.getInTimeS() != null && param.getInTimeE() != null,
                QDO.inTime, param.getInTimeS(), param.getInTimeE()
        ).
        andBetween(
                param.getOutTimeS() != null && param.getOutTimeE() != null,
                QDO.outTime, param.getOutTimeS(), param.getOutTimeE()
        ).build();

        JPAQuery<BatteryGuaranteesVO> jpaQuery = jpaQueryFactory.select(fieldsOfDTO())
                .from(QGDO).leftJoin(QDO).on(QGDO.code.eq(QDO.code))
                .where(predicate);
        return queryByPage(jpaQuery, param.getPageRequest());
    }

    private QBean<BatteryGuaranteesVO> fieldsOfDTO() {
        return Projections.bean(BatteryGuaranteesVO.class,
                QGDO.id,
                QGDO.code,
                QGDO.type,
                QGDO.ownerName,
                QGDO.ownerMobile,
                QGDO.idCard,
                QGDO.guaranteesTime,
                QGDO.vehicleType,
                QGDO.spuName,
                QGDO.vehicleSpecs,
                QGDO.mtnrv,
                QDO.fgCode,
                QDO.factoryCode,
                QDO.factoryName,
                QDO.prodCategory,
                QDO.prodCategory,
                QDO.prodSpecs,
                QDO.prodModel,
                QDO.producer,
                QDO.factoryOutTime,
                QDO.inTime,
                QDO.outTime,
                QGDO.custCode,
                QGDO.custCode2,
                QGDO.dealerName,
                QGDO.storeCode,
                QGDO.storeId,
                QGDO.storeName,
                QGDO.province,
                QGDO.provinceName,
                QGDO.saleRegion,
                QGDO.saleRegionName,
                QGDO.vehicleNo,
                QGDO.itemGroup2,
                QGDO.storeCode2
        );
    }

    public List<BatteryGuaranteesVO> findBatteryCodes(List<String> codes) {
        Predicate predicate = PredicateBuilder.builder().
                andEq(QGDO.deleteFlag,0).
                andIn(!codes.isEmpty(),QGDO.code,codes).build();
        JPAQuery<BatteryGuaranteesVO> jpaQuery = jpaQueryFactory.select(fieldsOfDTO())
                .from(QGDO)
                .where(predicate).leftJoin(QDO).on(QGDO.code.eq(QDO.code));
        return jpaQuery.fetch();
    }

    public List<BatteryGuaranteesVO> findByVehicleNo(List<String> vehicleNo) {
        Predicate predicate = PredicateBuilder.builder().
                andEq(QGDO.deleteFlag,0).
                andIn(!vehicleNo.isEmpty(),QGDO.vehicleNo,vehicleNo).build();
        JPAQuery<BatteryGuaranteesVO> jpaQuery = jpaQueryFactory.select(fieldsOfDTO())
                .from(QGDO)
                .where(predicate).leftJoin(QDO).on(QGDO.code.eq(QDO.code));
        return jpaQuery.fetch();
    }

    public void deletearBatteryGuaranteesByVehicleNo(List<String> vehicleNo) {
       super.updateDeleteFlagByValue(QGDO.vehicleNo, vehicleNo);
    }
}
