package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.BatteryVehicleDO;
import com.elitesland.yst.production.aftersale.model.entity.QBatteryVehicleDO;
import com.elitesland.yst.production.aftersale.model.param.VehicleQueryParam;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryVehicleVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

@Repository
public class BatteryVehicleRepoProc extends BaseRepoProc<BatteryVehicleDO> {

    private static final QBatteryVehicleDO QBDO = QBatteryVehicleDO.batteryVehicleDO;

    protected BatteryVehicleRepoProc() {
        super(QBDO);
    }

    public PagingVO<BatteryVehicleVO> vehicleList(VehicleQueryParam param) {
        Predicate predicate = PredicateBuilder.builder().
                andEq(QBDO.deleteFlag,0).
                andEq(StringUtils.hasText(param.getType()), QBDO.type, param.getType()).
                andLike(StringUtils.hasText(param.getSpuName()), QBDO.spuName, "%" + param.getSpuName() + "%").
                andEq(StringUtils.hasText(param.getCode()), QBDO.spuCode, "%" + param.getCode() + "%").
                andLike(StringUtils.hasText(param.getItemGroup2()), QBDO.itemGroup2, "%" + param.getItemGroup2() + "%")
                .build();

        JPAQuery<BatteryVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BatteryVehicleVO.class,
                        QBDO.id,
                        QBDO.type,
                        QBDO.status,
                        QBDO.spuName,
                        QBDO.spuCode,
                        QBDO.itemGroup2,
                        QBDO.batteryNum,
                        QBDO.sortNo,
                        QBDO.remark
                ))
                .from(QBDO)
                .where(predicate);
        return queryByPage(jpaQuery, param.getPageRequest());
    }


    public List<BatteryVehicleVO> vehicleInfo(String itemGroup2, String spuCode) {
        Predicate predicate = PredicateBuilder.builder().
                andEq(QBDO.deleteFlag,0).
                andEq(QBDO.status,1).
                andEq(StringUtils.hasText(spuCode), QBDO.spuCode, spuCode).
                andEq(StringUtils.hasText(itemGroup2), QBDO.itemGroup2, itemGroup2)
                .build();

        JPAQuery<BatteryVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BatteryVehicleVO.class,
                        QBDO.id,
                        QBDO.type,
                        QBDO.status,
                        QBDO.spuName,
                        QBDO.spuCode,
                        QBDO.itemGroup2,
                        QBDO.batteryNum,
                        QBDO.sortNo,
                        QBDO.remark
                ))
                .from(QBDO)
                .where(predicate);
        return jpaQuery.fetch();
    }

    public List<BatteryVehicleVO> findByIdAndSpuCode(Long id,String spuCode){
        Predicate predicate = PredicateBuilder.builder().
                andEq(QBDO.deleteFlag,0).
                andEq(StringUtils.hasText(spuCode), QBDO.spuCode, spuCode).
                andNe(id!=null, QBDO.id, id)
                .build();

        JPAQuery<BatteryVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BatteryVehicleVO.class,
                        QBDO.id,
                        QBDO.type,
                        QBDO.status,
                        QBDO.spuName,
                        QBDO.spuCode,
                        QBDO.itemGroup2,
                        QBDO.batteryNum,
                        QBDO.sortNo,
                        QBDO.remark
                ))
                .from(QBDO)
                .where(predicate);
        return jpaQuery.fetch();
    }
    public List<BatteryVehicleVO> findBySpuCodeAndItemSpec(String spuCode, String itemGroup2) {
        Predicate predicate = PredicateBuilder.builder().
                andEq(QBDO.deleteFlag,0).
                andEq(StringUtils.hasText(spuCode), QBDO.spuCode, spuCode).
                andEq(StringUtils.hasText(itemGroup2), QBDO.itemGroup2, itemGroup2)
                .build();

        JPAQuery<BatteryVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BatteryVehicleVO.class,
                        QBDO.id,
                        QBDO.type,
                        QBDO.status,
                        QBDO.spuName,
                        QBDO.spuCode,
                        QBDO.itemGroup2,
                        QBDO.batteryNum,
                        QBDO.sortNo,
                        QBDO.remark
                ))
                .from(QBDO)
                .where(predicate);
        return jpaQuery.fetch();
    }

    public void updateVehicleSetting(Long id, Integer status) {
        jpaQueryFactory.update(QBDO)
                .set(QBDO.status, status)
                .where(QBDO.id.eq(id))
                .execute();
    }
}
