package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.dto.ActivateInfoDTO;
import com.elitesland.yst.production.aftersale.dto.ActivateInfoVO;
import com.elitesland.yst.production.aftersale.model.entity.*;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jodd.util.StringPool;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.service.repo
 * @date 2023/7/7 15:06
 */
@Component
public class CarMaintainCardRepoProc {

    // 三包激活表
    private static final QCarMaintainCardDO qCarMaintainCardDO = QCarMaintainCardDO.carMaintainCardDO;
    // 车主信息表
    private static final QCarOwnerInfoDO qCarOwnerInfoDO = QCarOwnerInfoDO.carOwnerInfoDO;
    // 绑车信息表
    private static final QCarOwnerVehicleInfoDO qCarOwnerVehicleInfoDO = QCarOwnerVehicleInfoDO.carOwnerVehicleInfoDO;

    private static final QInsureInfoDO qInsureInfoDO = QInsureInfoDO.insureInfoDO;

    private static final QBatteryGuaranteesDO batteryGuaranteesDO = QBatteryGuaranteesDO.batteryGuaranteesDO;

    @Autowired
    protected JPAQueryFactory jpaQueryFactory;


    public PagingVO<CarMaintainCardVO> page(CarOwnerMaintainCardPageParam carMaintainCardPageParam) {

        JPAQuery<CarMaintainCardVO> query = select(CarMaintainCardVO.class)
                .where(bulidPredicates(carMaintainCardPageParam))
                .groupBy(qCarMaintainCardDO.vehicleNo);
        carMaintainCardPageParam.setPaging(query);
        carMaintainCardPageParam.fillOrders(query, qCarMaintainCardDO);

        return PagingVO.<CarMaintainCardVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }

    public CarMaintainCardVO get(Long id) {

        CarMaintainCardVO carMaintainCardVO = select(CarMaintainCardVO.class)
                .where(qCarMaintainCardDO.id.eq(id))
                .fetchOne();

        return carMaintainCardVO;

    }

    private <T> JPAQuery<T> select(Class<T> cls) {

        return jpaQueryFactory.select(Projections.bean(cls,
                qCarMaintainCardDO.id,
                qCarMaintainCardDO.vehicleNo,
                qCarMaintainCardDO.carName,
                qCarMaintainCardDO.vehicleType,
                qCarMaintainCardDO.purchaseTime,
                qCarMaintainCardDO.carOwnerId,
                qCarMaintainCardDO.tenantId,
                qCarMaintainCardDO.remark,
                qCarMaintainCardDO.createUserId,
                qCarMaintainCardDO.creator,
                qCarMaintainCardDO.createTime,
                qCarMaintainCardDO.modifyUserId,
                qCarMaintainCardDO.updater,
                qCarMaintainCardDO.modifyTime,
                qCarMaintainCardDO.deleteFlag,
                qCarMaintainCardDO.auditDataVersion,
                qCarMaintainCardDO.secBuId,
                qCarMaintainCardDO.secUserId,
                qCarMaintainCardDO.secOuId,
                qCarMaintainCardDO.belongOrgId,
                qCarMaintainCardDO.tenantOrgId,
                qCarMaintainCardDO.vehicleSpecs,
                qCarMaintainCardDO.vehicleColor,
                qCarMaintainCardDO.vehicleType,
                qCarMaintainCardDO.vehicleSource,
                qCarMaintainCardDO.vehicleBuyPrice,
                qCarMaintainCardDO.userIdCard,
                qCarMaintainCardDO.userSex,
                qCarMaintainCardDO.userArea,
                qCarMaintainCardDO.userBirthday,
                qCarMaintainCardDO.createTime,
                qCarMaintainCardDO.modifyTime.as("bindingTime"),
                qCarMaintainCardDO.remark,
                qCarMaintainCardDO.custName,
                qCarMaintainCardDO.region,
                qCarMaintainCardDO.custCode2,
                qCarOwnerInfoDO.userName,
                qCarOwnerInfoDO.userPhone,
                qCarMaintainCardDO.salesOutletsId,
                qCarMaintainCardDO.salesOutletsCode,
                qCarMaintainCardDO.salesOutletsName,
                        qInsureInfoDO.planName,
                        qInsureInfoDO.isCancel


        )).from(qCarMaintainCardDO)
                .join(qCarOwnerInfoDO).on(qCarOwnerInfoDO.carOwnerId.eq(qCarMaintainCardDO.carOwnerId))
                .leftJoin(qInsureInfoDO).on(qCarMaintainCardDO.vehicleNo.eq(qInsureInfoDO.vinNo)
                        .and(qInsureInfoDO.isCancel.eq(0))
                        .and(qInsureInfoDO.deleteFlag.eq(0)));
//                .leftJoin(qCarOwnerVehicleInfoDO).on(qCarOwnerVehicleInfoDO.vehicleNo.eq(qCarMaintainCardDO.vehicleNo)
//                        .and(qCarOwnerVehicleInfoDO.salesOutletsCode.eq(qCarMaintainCardDO.salesOutletsCode))
//                        .and(qCarOwnerVehicleInfoDO.deleteFlag.eq(0).and(qCarOwnerVehicleInfoDO.activatFlag.eq(true))));

    }

    private <T> JPAQuery<T> select2(Class<T> cls) {

        return jpaQueryFactory.select(Projections.bean(cls,
                qCarMaintainCardDO.id,
                qCarMaintainCardDO.vehicleNo,
                qCarMaintainCardDO.carName,
                qCarMaintainCardDO.vehicleType,
                qCarMaintainCardDO.purchaseTime,
                qCarMaintainCardDO.carOwnerId,
                qCarMaintainCardDO.tenantId,
                qCarMaintainCardDO.remark,
                qCarMaintainCardDO.createUserId,
                qCarMaintainCardDO.creator,
                qCarMaintainCardDO.createTime,
                qCarMaintainCardDO.modifyUserId,
                qCarMaintainCardDO.updater,
                qCarMaintainCardDO.modifyTime,
                qCarMaintainCardDO.deleteFlag,
                qCarMaintainCardDO.auditDataVersion,
                qCarMaintainCardDO.secBuId,
                qCarMaintainCardDO.secUserId,
                qCarMaintainCardDO.secOuId,
                qCarMaintainCardDO.belongOrgId,
                qCarMaintainCardDO.tenantOrgId,
                qCarMaintainCardDO.vehicleSpecs,
                qCarMaintainCardDO.vehicleColor,
                qCarMaintainCardDO.vehicleType,
                qCarMaintainCardDO.vehicleSource,
                qCarMaintainCardDO.vehicleBuyPrice,
                qCarMaintainCardDO.userIdCard,
                qCarMaintainCardDO.userSex,
                qCarMaintainCardDO.userArea,
                qCarMaintainCardDO.userBirthday,
                qCarMaintainCardDO.createTime,
                qCarMaintainCardDO.modifyTime.as("bindingTime"),
                qCarMaintainCardDO.remark,
                qCarOwnerInfoDO.userName,
                qCarOwnerInfoDO.userPhone,
                qCarMaintainCardDO.salesOutletsId,
                qCarMaintainCardDO.salesOutletsCode,
                qCarMaintainCardDO.salesOutletsName,
                qCarOwnerVehicleInfoDO.salesOutletsRegionName,
                qCarOwnerVehicleInfoDO.custCode2,
                qCarOwnerVehicleInfoDO.custName
        )).from(qCarMaintainCardDO)
                .join(qCarOwnerInfoDO).on(qCarOwnerInfoDO.carOwnerId.eq(qCarMaintainCardDO.carOwnerId))
                .leftJoin(qCarOwnerVehicleInfoDO).on(qCarOwnerVehicleInfoDO.vehicleNo.eq(qCarMaintainCardDO.vehicleNo));

    }

    private Predicate bulidPredicates(CarOwnerMaintainCardPageParam carMaintainCardPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 记录唯一ID
        if (null != carMaintainCardPageParam.getSalesOutletsIds()) {
            predicates.add(qCarMaintainCardDO.salesOutletsId.in(carMaintainCardPageParam.getSalesOutletsIds()));
        }

        if (!CollectionUtils.isEmpty(carMaintainCardPageParam.getSalesOutletsIds2())) {
            predicates.add(qCarMaintainCardDO.salesOutletsId.in(carMaintainCardPageParam.getSalesOutletsIds2()));
        }
        if(!StringUtils.isEmpty(carMaintainCardPageParam.getAppInfo())){
            predicates.add(qCarOwnerInfoDO.userPhone.like("%" + carMaintainCardPageParam.getAppInfo() + "%")
                    .or(qCarMaintainCardDO.vehicleNo.like("%"+carMaintainCardPageParam.getAppInfo()+"%")));
        }
        if(!StringUtils.isEmpty(carMaintainCardPageParam.getCustInfo())){
            predicates.add(qCarOwnerInfoDO.userPhone.like("%" + carMaintainCardPageParam.getCustInfo() + "%")
                    .or(qCarOwnerInfoDO.userName.like("%"+carMaintainCardPageParam.getCustInfo()+"%")));
        }

        // 车架号
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getVehicleNo())) {
            predicates.add(qCarMaintainCardDO.vehicleNo.eq(carMaintainCardPageParam.getVehicleNo()));
        }
        // 车辆名称
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getCarName())) {
            predicates.add(qCarMaintainCardDO.carName.eq(carMaintainCardPageParam.getCarName()));
        }
        // 车型
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getVehicleType())) {
            predicates.add(qCarMaintainCardDO.vehicleType.like("%" + carMaintainCardPageParam.getVehicleType() + "%"));
        }
        // 购买时间
        if (null != carMaintainCardPageParam.getPurchaseTimeStart()) {
            predicates.add(qCarMaintainCardDO.purchaseTime.gt(carMaintainCardPageParam.getPurchaseTimeStart()));
        }
        if (null != carMaintainCardPageParam.getPurchaseTimeEnd()) {
            predicates.add(qCarMaintainCardDO.purchaseTime.lt(carMaintainCardPageParam.getPurchaseTimeEnd()));
        }
        // 绑定时间
//        if (null != carMaintainCardPageParam.getBindingTimeStart()) {
//            predicates.add(qCarMaintainCardDO.createTime.gt(carMaintainCardPageParam.getBindingTimeStart()));
//        }
//        if (null != carMaintainCardPageParam.getBindingTimeEnd()) {
//            predicates.add(qCarMaintainCardDO.createTime.lt(carMaintainCardPageParam.getBindingTimeEnd()));
//        }
        // 产品要求绑定时间查询条件更改为更新时间
        if (null != carMaintainCardPageParam.getBindingTimeStart()) {
            predicates.add(qCarMaintainCardDO.modifyTime.gt(carMaintainCardPageParam.getBindingTimeStart()));
        }
        if (null != carMaintainCardPageParam.getBindingTimeEnd()) {
            predicates.add(qCarMaintainCardDO.modifyTime.lt(carMaintainCardPageParam.getBindingTimeEnd()));
        }
        // 车主id
        if (null != carMaintainCardPageParam.getCarOwnerId()) {
            predicates.add(qCarMaintainCardDO.carOwnerId.eq(carMaintainCardPageParam.getCarOwnerId()));
        }

        if (!org.springframework.util.CollectionUtils.isEmpty(carMaintainCardPageParam.getIdList())) {
            predicates.add(qCarMaintainCardDO.id.in(carMaintainCardPageParam.getIdList()));
        }
//        // 租户ID
//        if (null != carMaintainCardPageParam.getTenantId()) {
//            predicates.add(qCarMaintainCardDO.tenantId.eq(carMaintainCardPageParam.getTenantId()));
//        }
//        // 备注
//        if (null != carMaintainCardPageParam.getRemark()) {
//            predicates.add(qCarMaintainCardDO.remark.eq(carMaintainCardPageParam.getRemark()));
//        }
//        // 记录创建者ID
//        if (null != carMaintainCardPageParam.getCreateUserId()) {
//            predicates.add(qCarMaintainCardDO.createUserId.eq(carMaintainCardPageParam.getCreateUserId()));
//        }
//        // 记录创建者
//        if (null != carMaintainCardPageParam.getCreator()) {
//            predicates.add(qCarMaintainCardDO.creator.eq(carMaintainCardPageParam.getCreator()));
//        }
//        // 记录创建时间
//        if (null != carMaintainCardPageParam.getCreateTime()) {
//            predicates.add(qCarMaintainCardDO.createTime.eq(carMaintainCardPageParam.getCreateTime()));
//        }
//        // 记录最后更新者ID
//        if (null != carMaintainCardPageParam.getModifyUserId()) {
//            predicates.add(qCarMaintainCardDO.modifyUserId.eq(carMaintainCardPageParam.getModifyUserId()));
//        }
//        // 记录最后更新者
//        if (null != carMaintainCardPageParam.getUpdater()) {
//            predicates.add(qCarMaintainCardDO.updater.eq(carMaintainCardPageParam.getUpdater()));
//        }
//        // 记录最后更新时间
//        if (null != carMaintainCardPageParam.getModifyTime()) {
//            predicates.add(qCarMaintainCardDO.modifyTime.eq(carMaintainCardPageParam.getModifyTime()));
//        }
//        // 记录最后更新时间
//        if (null != carMaintainCardPageParam.getDeleteFlag()) {
//            predicates.add(qCarMaintainCardDO.deleteFlag.eq(carMaintainCardPageParam.getDeleteFlag()));
//        }
//        // 锁版本
//        if (null != carMaintainCardPageParam.getAuditDataVersion()) {
//            predicates.add(qCarMaintainCardDO.auditDataVersion.eq(carMaintainCardPageParam.getAuditDataVersion()));
//        }
//        // 数据归属组织id
//        if (null != carMaintainCardPageParam.getSecBuId()) {
//            predicates.add(qCarMaintainCardDO.secBuId.eq(carMaintainCardPageParam.getSecBuId()));
//        }
//        // 数据归属雇员id
//        if (null != carMaintainCardPageParam.getSecUserId()) {
//            predicates.add(qCarMaintainCardDO.secUserId.eq(carMaintainCardPageParam.getSecUserId()));
//        }
//        // 数据归属公司id
//        if (null != carMaintainCardPageParam.getSecOuId()) {
//            predicates.add(qCarMaintainCardDO.secOuId.eq(carMaintainCardPageParam.getSecOuId()));
//        }
//        // 所属组织ID
//        if (null != carMaintainCardPageParam.getBelongOrgId()) {
//            predicates.add(qCarMaintainCardDO.belongOrgId.eq(carMaintainCardPageParam.getBelongOrgId()));
//        }
//        // 租户组织ID
//        if (null != carMaintainCardPageParam.getTenantOrgId()) {
//            predicates.add(qCarMaintainCardDO.tenantOrgId.eq(carMaintainCardPageParam.getTenantOrgId()));
//        }
        // 车辆规格
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getVehicleSpecs())) {
            predicates.add(qCarMaintainCardDO.vehicleSpecs.eq(carMaintainCardPageParam.getVehicleSpecs()));
        }
        // 车辆颜色
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getVehicleColor())) {
            predicates.add(qCarMaintainCardDO.vehicleColor.eq(carMaintainCardPageParam.getVehicleColor()));
        }
        // 车主信息
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getUserName())) {
            predicates.add(qCarOwnerInfoDO.userName.like("%" + carMaintainCardPageParam.getUserName() + "%"));
        }
        if (StringUtils.isNotBlank(carMaintainCardPageParam.getUserPhone())) {
            predicates.add(qCarOwnerInfoDO.userPhone.like("%" + carMaintainCardPageParam.getUserPhone() + "%"));
        }

        if(StringUtils.isNotEmpty(carMaintainCardPageParam.getSalesOutletsRegion())){
            predicates.add(qCarMaintainCardDO.region.eq(carMaintainCardPageParam.getSalesOutletsRegion()));
        }

        if(StringUtils.isNotEmpty(carMaintainCardPageParam.getCustCode2())){
            predicates.add(qCarMaintainCardDO.custCode2.eq(carMaintainCardPageParam.getCustCode2()));
        }

        if(StringUtils.isNotEmpty(carMaintainCardPageParam.getCustName())){
            predicates.add(qCarMaintainCardDO.custName.eq(carMaintainCardPageParam.getCustName()));
        }

        if(StringUtils.isNotEmpty(carMaintainCardPageParam.getSalesOutletsCode())){
            predicates.add(qCarMaintainCardDO.salesOutletsCode.eq(carMaintainCardPageParam.getSalesOutletsCode()));
        }

        if(null != carMaintainCardPageParam.getSalesOutletsId()){
            predicates.add(qCarMaintainCardDO.salesOutletsId.eq(carMaintainCardPageParam.getSalesOutletsId()));
        }

        if(org.springframework.util.StringUtils.hasText(carMaintainCardPageParam.getBatteryCode())){
            predicates.add(qCarMaintainCardDO.vehicleNo
                    .in(JPAExpressions
                            .select(batteryGuaranteesDO.vehicleNo)
                            .from(batteryGuaranteesDO)
                            .where(batteryGuaranteesDO.type.eq("电池"))
                            .where(batteryGuaranteesDO.code.eq(carMaintainCardPageParam.getBatteryCode()))));
        }

        if(org.springframework.util.StringUtils.hasText(carMaintainCardPageParam.getChargerCode())){
            predicates.add(qCarMaintainCardDO.vehicleNo
                    .in(JPAExpressions
                            .select(batteryGuaranteesDO.vehicleNo)
                            .from(batteryGuaranteesDO)
                            .where(batteryGuaranteesDO.type.eq("充电器"))
                            .where(batteryGuaranteesDO.code.eq(carMaintainCardPageParam.getChargerCode()))));
        }

        //predicates.add(qInsureInfoDO.isCancel.eq(Integer.valueOf("0")).and(qInsureInfoDO.deleteFlag.eq(Integer.valueOf("0"))));

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }

    public List<ActivateInfoVO> getActivateNum(ActivateInfoDTO dto) {
        List<Predicate> predicate = new ArrayList<>();
        // 客户号
        if (StringUtils.isNotEmpty(dto.getCustCode2())){
            predicate.add(qCarMaintainCardDO.custCode2.eq(dto.getCustCode2()));
        }
        // 客户号集合
        if (CollectionUtils.isNotEmpty(dto.getCustCode2List())){
            predicate.add(qCarMaintainCardDO.custCode2.in(dto.getCustCode2List()));
        }
        // 门店id
        if (ObjectUtils.isNotEmpty(dto.getSalesOutletsId())){
            predicate.add(qCarMaintainCardDO.salesOutletsId.eq(dto.getSalesOutletsId()));
        }
        // 门店id集合
        if (CollectionUtils.isNotEmpty(dto.getIds())){
            predicate.add(qCarMaintainCardDO.salesOutletsId.in(dto.getIds()));
        }
        // 门店号
        if (StringUtils.isNotEmpty(dto.getSalesOutletsCode())){
            predicate.add(qCarMaintainCardDO.salesOutletsCode.eq(dto.getSalesOutletsCode()));
        }
        // 开始
        if (!ObjectUtils.isEmpty(dto.getCreateTimeS())){
            predicate.add(qCarMaintainCardDO.createTime.goe(dto.getCreateTimeS()));
        }
        // 结束
        if (!ObjectUtils.isEmpty(dto.getCreateTimeE())){
            predicate.add(qCarMaintainCardDO.createTime.loe(dto.getCreateTimeE()));
        }
        JPAQuery<ActivateInfoVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ActivateInfoVO.class,
                        qCarMaintainCardDO.salesOutletsName,
                        qCarMaintainCardDO.vehicleType,
                        qCarMaintainCardDO.salesOutletsId,
                        qCarMaintainCardDO.custCode2
                )).from(qCarMaintainCardDO).where(ExpressionUtils.allOf(predicate));
        return jpaQuery.fetch();
    }

    public Map<String, String> findBattery(List<String> vehicleNo){
        return jpaQueryFactory
                .select(batteryGuaranteesDO.vehicleNo, batteryGuaranteesDO.code)
                .from(batteryGuaranteesDO)
                .where(batteryGuaranteesDO.vehicleNo.in(vehicleNo))
                .where(batteryGuaranteesDO.type.eq("电池"))
                .fetch()
                .stream()
                .collect(Collectors.toMap(x -> x.get(batteryGuaranteesDO.vehicleNo),
                        x -> x.get(batteryGuaranteesDO.code),
                        (v1, v2) -> v1 + "," + v2));
    }

    public Map<String, String> findCharger(List<String> vehicleNo){
        return jpaQueryFactory
                .select(batteryGuaranteesDO.vehicleNo, batteryGuaranteesDO.code)
                .from(batteryGuaranteesDO)
                .where(batteryGuaranteesDO.vehicleNo.in(vehicleNo))
                .where(batteryGuaranteesDO.type.eq("充电器"))
                .fetch()
                .stream()
                .collect(Collectors.toMap(x -> x.get(batteryGuaranteesDO.vehicleNo),
                        x -> x.get(batteryGuaranteesDO.code),
                        (v1, v2) -> v1 + "," + v2));
    }

    public int existByPhoneAId(String userPhone, String userIdcard) {
        int res = 0;
        if(userIdcard != null) {
            res = jpaQueryFactory.select(qCarMaintainCardDO.id)
                    .from(qCarMaintainCardDO)
                    .where(qCarMaintainCardDO.userIdCard.eq(userIdcard))
                    .where(qCarMaintainCardDO.deleteFlag.eq(0))
                    .fetch().size();
        }
        return res;
    }
}
